/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ldap.pojo.LdapResponse;
import org.apache.asn1new.primitives.OID;
import org.apache.asn1new.primitives.OctetString;

public class ExtendedResponse
extends LdapResponse {
    private OID responseName;
    private OctetString response;
    private transient int extendedResponseLength;

    public int getMessageType() {
        return 10;
    }

    public String getResponseName() {
        return this.responseName == null ? "" : this.responseName.toString();
    }

    public void setResponseName(OID responseName) {
        this.responseName = responseName;
    }

    public OctetString getResponse() {
        return this.response;
    }

    public void setResponse(OctetString response) {
        this.response = response;
    }

    public int computeLength() {
        this.extendedResponseLength = super.computeLength();
        if (this.responseName != null) {
            this.extendedResponseLength += 1 + Length.getNbBytes((int)this.responseName.getOIDLength()) + this.responseName.getOIDLength();
            if (this.response != null) {
                this.extendedResponseLength += 1 + Length.getNbBytes((int)this.response.getNbBytes()) + this.response.getNbBytes();
            }
        }
        return 1 + Length.getNbBytes((int)this.extendedResponseLength) + this.extendedResponseLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)120);
            buffer.put(Length.getBytes((int)this.extendedResponseLength));
            super.encode(buffer);
            if (this.responseName != null) {
                buffer.put((byte)-118);
                buffer.put(Length.getBytes((int)this.responseName.getOIDLength()));
                if (this.responseName.getOIDLength() != 0) {
                    buffer.put(this.responseName.getOID());
                }
            }
            if (this.response != null) {
                buffer.put((byte)-117);
                buffer.put(Length.getBytes((int)this.response.getNbBytes()));
                if (this.response.getNbBytes() != 0) {
                    buffer.put(this.response.getValue());
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Extended Response\n");
        sb.append(super.toString());
        if (this.responseName != null) {
            sb.append("        Response name :'").append(this.responseName.toString()).append("'\n");
        }
        if (this.response != null) {
            sb.append("        Response :'").append(this.response.toString()).append("'\n");
        }
        return sb.toString();
    }
}

