/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.codec.primitives.LdapRDN;
import org.apache.asn1new.ldap.pojo.LdapMessage;

public class ModifyDNRequest
extends LdapMessage {
    private LdapDN entry;
    private LdapRDN newRDN;
    private boolean deleteOldRDN;
    private LdapDN newSuperior;
    private transient int modifyDNRequestLength;

    public int getMessageType() {
        return 11;
    }

    public String getEntry() {
        return this.entry == null ? "" : this.entry.getString();
    }

    public void setEntry(LdapDN entry) {
        this.entry = entry;
    }

    public boolean isDeleteOldRDN() {
        return this.deleteOldRDN;
    }

    public void setDeleteOldRDN(boolean deleteOldRDN) {
        this.deleteOldRDN = deleteOldRDN;
    }

    public String getNewRDN() {
        return this.newRDN == null ? "" : this.newRDN.getString();
    }

    public void setNewRDN(LdapRDN newRDN) {
        this.newRDN = newRDN;
    }

    public String getNewSuperior() {
        return this.newSuperior == null ? "" : this.newSuperior.getString();
    }

    public void setNewSuperior(LdapDN newSuperior) {
        this.newSuperior = newSuperior;
    }

    public int computeLength() {
        this.modifyDNRequestLength = 1 + Length.getNbBytes((int)this.entry.getNbBytes()) + this.entry.getNbBytes() + 1 + Length.getNbBytes((int)this.newRDN.getNbBytes()) + this.newRDN.getNbBytes() + 1 + 1 + 1;
        if (this.newSuperior != null) {
            this.modifyDNRequestLength += 1 + Length.getNbBytes((int)this.newSuperior.getNbBytes()) + this.newSuperior.getNbBytes();
        }
        return 1 + Length.getNbBytes((int)this.modifyDNRequestLength) + this.modifyDNRequestLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)108);
            buffer.put(Length.getBytes((int)this.modifyDNRequestLength));
            Value.encode((ByteBuffer)buffer, (byte[])this.entry.getBytes());
            Value.encode((ByteBuffer)buffer, (byte[])this.newRDN.getBytes());
            Value.encode((ByteBuffer)buffer, (boolean)this.deleteOldRDN);
            if (this.newSuperior != null) {
                buffer.put((byte)-128);
                buffer.put(Length.getBytes((int)this.newSuperior.getNbBytes()));
                if (this.newSuperior.getNbBytes() != 0) {
                    buffer.put(this.newSuperior.getBytes());
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    ModifyDN Response\n");
        sb.append("        Entry : '").append(this.entry).append("'\n");
        sb.append("        New RDN : '").append(this.newRDN.toString()).append("'\n");
        sb.append("        Delete old RDN : ").append(this.deleteOldRDN).append("\n");
        if (this.newSuperior != null) {
            sb.append("        New superior : '").append(this.newSuperior.toString()).append("'\n");
        }
        return sb.toString();
    }
}

