/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.ldap.pojo.LdapAuthentication;
import org.apache.asn1new.ldap.pojo.SimpleAuthentication;
import org.apache.asn1new.primitives.OctetString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslCredentials
extends LdapAuthentication {
    private static Logger log = LoggerFactory.getLogger((Class)SimpleAuthentication.class);
    private LdapString mechanism;
    private OctetString credentials;

    public OctetString getCredentials() {
        return this.credentials;
    }

    public void setCredentials(OctetString credentials) {
        this.credentials = credentials;
    }

    public String getMechanism() {
        return this.mechanism == null ? null : this.mechanism.getString();
    }

    public void setMechanism(LdapString mechanism) {
        this.mechanism = mechanism;
    }

    public int computeLength() {
        int saslLength = 1 + Length.getNbBytes((int)this.mechanism.getNbBytes()) + this.mechanism.getNbBytes();
        if (this.credentials != null) {
            saslLength += 1 + Length.getNbBytes((int)this.credentials.getNbBytes()) + this.credentials.getNbBytes();
        }
        if (log.isDebugEnabled()) {
            log.debug("SASL Authentication length : " + saslLength);
        }
        return saslLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            log.error("Cannot put a PDU in a null buffer !");
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)-125);
            buffer.put(Length.getBytes((int)this.mechanism.getNbBytes()));
            buffer.put(this.mechanism.getBytes());
            if (this.credentials != null) {
                Value.encode((ByteBuffer)buffer, (OctetString)this.credentials);
            }
        }
        catch (BufferOverflowException boe) {
            log.error("The PDU buffer size is too small !");
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("        Sasl credentials\n");
        sb.append("            Mechanism :'").append(this.mechanism.toString()).append("'\n");
        if (this.credentials != null) {
            sb.append("            Credentials :'").append(this.credentials.toString()).append("'\n");
        }
        return sb.toString();
    }
}

