/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo;

import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.ldap.pojo.filters.Filter;
import org.apache.asn1new.util.StringUtils;

public class SearchRequest
extends LdapMessage {
    private LdapDN baseObject;
    private int scope;
    private int derefAliases;
    private int sizeLimit;
    private int timeLimit;
    private boolean typesOnly;
    private Filter filter;
    private Attributes attributes;
    private transient Filter currentFilter = null;
    private transient int searchRequestLength;
    private transient int attributeDescriptionListLength;

    public int getMessageType() {
        return 15;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void addAttribute(LdapString attribute) {
        this.attributes.put(new BasicAttribute(StringUtils.lowerCase((String)attribute.getString())));
    }

    public void initAttributes() {
        this.attributes = new BasicAttributes(true);
    }

    public String getBaseObject() {
        return this.baseObject == null ? null : this.baseObject.getString();
    }

    public void setBaseObject(LdapDN baseObject) {
        this.baseObject = baseObject;
    }

    public int getDerefAliases() {
        return this.derefAliases;
    }

    public void setDerefAliases(int derefAliases) {
        this.derefAliases = derefAliases;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public boolean isTypesOnly() {
        return this.typesOnly;
    }

    public void setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    public Filter getCurrentFilter() {
        return this.currentFilter;
    }

    public void setCurrentFilter(Filter currentFilter) {
        this.currentFilter = currentFilter;
    }

    public int computeLength() {
        this.searchRequestLength = 0;
        this.searchRequestLength += 1 + Length.getNbBytes((int)this.baseObject.getNbBytes()) + this.baseObject.getNbBytes();
        this.searchRequestLength += 3;
        this.searchRequestLength += 3;
        this.searchRequestLength += 2 + Value.getNbBytes((int)this.sizeLimit);
        this.searchRequestLength += 2 + Value.getNbBytes((int)this.timeLimit);
        this.searchRequestLength += 3;
        this.searchRequestLength += this.filter.computeLength();
        this.attributeDescriptionListLength = 0;
        if (this.attributes != null && this.attributes.size() != 0) {
            NamingEnumeration<? extends Attribute> attributeIterator = this.attributes.getAll();
            while (attributeIterator.hasMoreElements()) {
                BasicAttribute attribute = (BasicAttribute)attributeIterator.nextElement();
                try {
                    int idLength = attribute.getID().getBytes("UTF-8").length;
                    this.attributeDescriptionListLength += 1 + Length.getNbBytes((int)idLength) + idLength;
                }
                catch (UnsupportedEncodingException uee) {
                    this.attributeDescriptionListLength += 2;
                }
            }
        }
        this.searchRequestLength += 1 + Length.getNbBytes((int)this.attributeDescriptionListLength) + this.attributeDescriptionListLength;
        return 1 + Length.getNbBytes((int)this.searchRequestLength) + this.searchRequestLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)99);
            buffer.put(Length.getBytes((int)this.searchRequestLength));
            Value.encode((ByteBuffer)buffer, (byte[])this.baseObject.getBytes());
            Value.encodeEnumerated((ByteBuffer)buffer, (int)this.scope);
            Value.encodeEnumerated((ByteBuffer)buffer, (int)this.derefAliases);
            Value.encode((ByteBuffer)buffer, (int)this.sizeLimit);
            Value.encode((ByteBuffer)buffer, (int)this.timeLimit);
            Value.encode((ByteBuffer)buffer, (boolean)this.typesOnly);
            this.filter.encode(buffer);
            buffer.put((byte)48);
            buffer.put(Length.getBytes((int)this.attributeDescriptionListLength));
            if (this.attributes != null && this.attributes.size() != 0) {
                NamingEnumeration<? extends Attribute> attributeIterator = this.attributes.getAll();
                while (attributeIterator.hasMoreElements()) {
                    BasicAttribute attribute = (BasicAttribute)attributeIterator.nextElement();
                    Value.encode((ByteBuffer)buffer, (String)attribute.getID());
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    private String buildFilter() {
        if (this.filter == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(((Object)((Object)this.filter)).toString());
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Search Request\n");
        sb.append("        Base Object : '").append(this.baseObject).append("'\n");
        sb.append("        Scope : ");
        switch (this.scope) {
            case 0: {
                sb.append("base object");
                break;
            }
            case 1: {
                sb.append("single level");
                break;
            }
            case 2: {
                sb.append("whole subtree");
            }
        }
        sb.append("\n");
        sb.append("        Deref Aliases : ");
        switch (this.derefAliases) {
            case 0: {
                sb.append("never Deref Aliases");
                break;
            }
            case 1: {
                sb.append("deref In Searching");
                break;
            }
            case 2: {
                sb.append("deref Finding Base Obj");
                break;
            }
            case 3: {
                sb.append("deref Always");
            }
        }
        sb.append("\n");
        sb.append("        Size Limit : ");
        if (this.sizeLimit == 0) {
            sb.append("no limit");
        } else {
            sb.append(this.sizeLimit);
        }
        sb.append("\n");
        sb.append("        Time Limit : ");
        if (this.timeLimit == 0) {
            sb.append("no limit");
        } else {
            sb.append(this.timeLimit);
        }
        sb.append("\n");
        sb.append("        Types Only : ").append(this.typesOnly).append("\n");
        sb.append("        Filter : '").append(this.buildFilter()).append("'\n");
        return sb.toString();
    }
}

