/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo;

import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.primitives.OctetString;
import org.apache.asn1new.util.StringUtils;

public class SearchResultEntry
extends LdapMessage {
    private LdapDN objectName;
    private Attributes partialAttributeList;
    private transient Attribute currentAttributeValue;
    private transient int searchResultEntryLength;
    private transient int attributesLength;
    private transient List attributeLength;
    private transient List valsLength;

    public int getMessageType() {
        return 17;
    }

    public String getObjectName() {
        return this.objectName == null ? null : this.objectName.getString();
    }

    public void setObjectName(LdapDN objectName) {
        this.objectName = objectName;
    }

    public Attributes getPartialAttributeList() {
        return this.partialAttributeList;
    }

    public void setPartialAttributeList(Attributes partialAttributeList) {
        this.partialAttributeList = partialAttributeList;
    }

    public void addPartialAttributeList() {
        if (this.currentAttributeValue == null) {
            this.partialAttributeList = new BasicAttributes(true);
        }
    }

    public void addAttributeValues(LdapString type) {
        this.currentAttributeValue = new BasicAttribute(StringUtils.lowerCase((String)type.getString()));
        this.partialAttributeList.put(this.currentAttributeValue);
    }

    public void addAttributeValue(OctetString value) {
        this.currentAttributeValue.add(value);
    }

    public int computeLength() {
        this.searchResultEntryLength = 1 + Length.getNbBytes((int)this.objectName.getNbBytes()) + this.objectName.getNbBytes();
        this.attributesLength = 0;
        if (this.partialAttributeList != null && this.partialAttributeList.size() != 0) {
            NamingEnumeration<? extends Attribute> attributes = this.partialAttributeList.getAll();
            this.attributeLength = new LinkedList();
            this.valsLength = new LinkedList();
            while (attributes.hasMoreElements()) {
                Attribute attribute = (Attribute)attributes.nextElement();
                int localAttributeLength = 0;
                int localValuesLength = 0;
                int idLength = attribute.getID().getBytes().length;
                localAttributeLength = 1 + Length.getNbBytes((int)idLength) + idLength;
                try {
                    NamingEnumeration<?> values = attribute.getAll();
                    if (values.hasMoreElements()) {
                        localValuesLength = 0;
                        while (values.hasMoreElements()) {
                            Object value = values.next();
                            if (value instanceof String) {
                                String stringValue = (String)value;
                                try {
                                    int stringLength = stringValue.getBytes("UTF-8").length;
                                    localValuesLength += 1 + Length.getNbBytes((int)stringLength) + stringLength;
                                }
                                catch (UnsupportedEncodingException uee) {
                                    localValuesLength += 2;
                                }
                                continue;
                            }
                            if (value instanceof OctetString) {
                                OctetString octetStringValue = (OctetString)value;
                                localValuesLength += 1 + Length.getNbBytes((int)octetStringValue.getNbBytes()) + octetStringValue.getNbBytes();
                                continue;
                            }
                            byte[] binaryValue = (byte[])value;
                            localValuesLength += 1 + Length.getNbBytes((int)binaryValue.length) + binaryValue.length;
                        }
                        localAttributeLength += 1 + Length.getNbBytes((int)localValuesLength) + localValuesLength;
                    }
                }
                catch (NamingException ne) {
                    return 0;
                }
                this.attributesLength += 1 + Length.getNbBytes((int)localAttributeLength) + localAttributeLength;
                this.attributeLength.add(new Integer(localAttributeLength));
                this.valsLength.add(new Integer(localValuesLength));
            }
        }
        this.searchResultEntryLength += 1 + Length.getNbBytes((int)this.attributesLength) + this.attributesLength;
        return 1 + Length.getNbBytes((int)this.searchResultEntryLength) + this.searchResultEntryLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        block10: {
            if (buffer == null) {
                throw new EncoderException("Cannot put a PDU in a null buffer !");
            }
            try {
                buffer.put((byte)100);
                buffer.put(Length.getBytes((int)this.searchResultEntryLength));
                Value.encode((ByteBuffer)buffer, (byte[])this.objectName.getBytes());
                buffer.put((byte)48);
                buffer.put(Length.getBytes((int)this.attributesLength));
                if (this.partialAttributeList == null || this.partialAttributeList.size() == 0) break block10;
                NamingEnumeration<? extends Attribute> attributes = this.partialAttributeList.getAll();
                int attributeNumber = 0;
                while (attributes.hasMoreElements()) {
                    Attribute attribute = (Attribute)attributes.nextElement();
                    buffer.put((byte)48);
                    int localAttributeLength = (Integer)this.attributeLength.get(attributeNumber);
                    buffer.put(Length.getBytes((int)localAttributeLength));
                    Value.encode((ByteBuffer)buffer, (String)attribute.getID());
                    buffer.put((byte)49);
                    int localValuesLength = (Integer)this.valsLength.get(attributeNumber);
                    buffer.put(Length.getBytes((int)localValuesLength));
                    try {
                        NamingEnumeration<?> values = attribute.getAll();
                        if (values.hasMoreElements()) {
                            while (values.hasMoreElements()) {
                                Object value = values.next();
                                if (value instanceof String) {
                                    Value.encode((ByteBuffer)buffer, (String)((String)value));
                                    continue;
                                }
                                if (value instanceof OctetString) {
                                    Value.encode((ByteBuffer)buffer, (OctetString)((OctetString)value));
                                    continue;
                                }
                                Value.encode((ByteBuffer)buffer, (byte[])((byte[])value));
                            }
                        }
                    }
                    catch (NamingException ne) {
                        throw new EncoderException("Cannot enumerate the values");
                    }
                    ++attributeNumber;
                }
            }
            catch (BufferOverflowException boe) {
                throw new EncoderException("The PDU buffer size is too small !");
            }
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Search Result Entry\n");
        sb.append("        Object Name : '").append(this.objectName.toString()).append("'\n");
        sb.append("        Attributes\n");
        if (this.partialAttributeList == null || this.partialAttributeList.size() == 0) {
            sb.append("            No attributes\n");
        } else {
            NamingEnumeration<? extends Attribute> attributes = this.partialAttributeList.getAll();
            while (attributes.hasMoreElements()) {
                Attribute attribute = (Attribute)attributes.nextElement();
                sb.append("            Name : '").append(attribute.getID()).append("'\n");
                try {
                    NamingEnumeration<?> values = attribute.getAll();
                    if (values.hasMoreElements()) {
                        sb.append("            Values\n");
                        while (values.hasMore()) {
                            Object value = values.nextElement();
                            sb.append("                '");
                            if (value instanceof String) {
                                sb.append((String)value);
                            } else if (value instanceof OctetString) {
                                sb.append(StringUtils.dumpBytes((byte[])((OctetString)value).getValue()));
                            } else {
                                sb.append(StringUtils.dumpBytes((byte[])((byte[])value)));
                            }
                            sb.append("'\n");
                        }
                        continue;
                    }
                    sb.append("            No Values\n");
                }
                catch (NamingException ne) {
                    sb.append("            Error while reading attribute.\n ");
                }
            }
        }
        return sb.toString();
    }
}

