/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ldap.pojo.LdapAuthentication;
import org.apache.asn1new.primitives.OctetString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAuthentication
extends LdapAuthentication {
    private static Logger log = LoggerFactory.getLogger((Class)SimpleAuthentication.class);
    private OctetString simple;

    public OctetString getSimple() {
        return this.simple;
    }

    public void setSimple(OctetString simple) {
        this.simple = simple;
    }

    public int computeLength() {
        int length = 1 + Length.getNbBytes((int)this.simple.getNbBytes()) + this.simple.getNbBytes();
        if (log.isDebugEnabled()) {
            log.debug("Simple Authentication length : " + length);
        }
        return length;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            log.error("Cannot put a PDU in a null buffer !");
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)-128);
            buffer.put(Length.getBytes((int)this.simple.getNbBytes()));
            buffer.put(this.simple.getValue());
        }
        catch (BufferOverflowException boe) {
            log.error("The PDU buffer size is too small !");
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        return this.simple == null ? "null" : this.simple.toString();
    }
}

