/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo.filters;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.pojo.AttributeValueAssertion;
import org.apache.asn1new.ldap.pojo.filters.Filter;
import org.apache.asn1new.primitives.OctetString;

public class AttributeValueAssertionFilter
extends Filter {
    private AttributeValueAssertion assertion;
    private int filterType;
    private transient int avaLength;

    public AttributeValueAssertionFilter(int filterType) {
        this.filterType = filterType;
    }

    public AttributeValueAssertion getAssertion() {
        return this.assertion;
    }

    public void setAssertion(AttributeValueAssertion assertion) {
        this.assertion = assertion;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public void setFilterType(int filterType) {
        this.filterType = filterType;
    }

    public int computeLength() {
        this.avaLength = 0;
        int attributeDescLength = this.assertion.getAttributeDesc().length();
        this.avaLength = 1 + Length.getNbBytes((int)attributeDescLength) + attributeDescLength;
        int assertionValueLength = this.assertion.getAssertionValue().getNbBytes();
        this.avaLength += 1 + Length.getNbBytes((int)assertionValueLength) + assertionValueLength;
        return 1 + Length.getNbBytes((int)this.avaLength) + this.avaLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            switch (this.filterType) {
                case 0: {
                    buffer.put((byte)-93);
                    break;
                }
                case 2: {
                    buffer.put((byte)-90);
                    break;
                }
                case 1: {
                    buffer.put((byte)-91);
                    break;
                }
                case 3: {
                    buffer.put((byte)-88);
                }
            }
            buffer.put(Length.getBytes((int)this.avaLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        Value.encode((ByteBuffer)buffer, (String)this.assertion.getAttributeDesc());
        Value.encode((ByteBuffer)buffer, (OctetString)this.assertion.getAssertionValue());
        return buffer;
    }

    public String toString() {
        return this.assertion.toStringRFC2254(this.filterType);
    }
}

