/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo.filters;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ldap.pojo.filters.Filter;

public abstract class ConnectorFilter
extends Filter {
    protected ArrayList filterSet;
    protected transient int filtersLength;

    public void addFilter(Filter filter) throws DecoderException {
        if (this.filterSet == null) {
            this.filterSet = new ArrayList();
        }
        this.filterSet.add(filter);
    }

    public ArrayList getFilterSet() {
        return this.filterSet;
    }

    public int computeLength() {
        int connectorFilterLength = 0;
        if (this.filterSet != null && this.filterSet.size() != 0) {
            Iterator filterIterator = this.filterSet.iterator();
            while (filterIterator.hasNext()) {
                Filter filter = (Filter)((Object)filterIterator.next());
                connectorFilterLength += filter.computeLength();
            }
        }
        return connectorFilterLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        if (this.filterSet != null && this.filterSet.size() != 0) {
            Iterator filterIterator = this.filterSet.iterator();
            while (filterIterator.hasNext()) {
                Filter filter = (Filter)((Object)filterIterator.next());
                filter.encode(buffer);
            }
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.filterSet != null && this.filterSet.size() != 0) {
            Iterator filterIterator = this.filterSet.iterator();
            while (filterIterator.hasNext()) {
                Filter filter = (Filter)((Object)filterIterator.next());
                sb.append('(').append(((Object)((Object)filter)).toString()).append(')');
            }
        }
        return sb.toString();
    }
}

