/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo.filters;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ldap.pojo.filters.ConnectorFilter;
import org.apache.asn1new.ldap.pojo.filters.Filter;

public class NotFilter
extends ConnectorFilter {
    public void addFilter(Filter filter) throws DecoderException {
        if (this.filterSet != null) {
            throw new DecoderException("Cannot have more than one Filter within a Not Filter");
        }
        super.addFilter(filter);
    }

    public Filter getNotFilter() {
        return (Filter)((Object)this.filterSet.get(0));
    }

    public void setNotFilter(Filter notFilter) throws DecoderException {
        if (this.filterSet != null) {
            throw new DecoderException("Cannot have more than one Filter within a Not Filter");
        }
        super.addFilter(notFilter);
    }

    public int computeLength() {
        this.filtersLength = super.computeLength();
        return 1 + Length.getNbBytes((int)this.filtersLength) + this.filtersLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)-94);
            buffer.put(Length.getBytes((int)this.filtersLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        super.encode(buffer);
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('!').append(super.toString());
        return sb.toString();
    }
}

