/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo.filters;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.ldap.pojo.filters.Filter;

public class PresentFilter
extends Filter {
    private LdapString attributeDescription;

    public LdapString getAttributeDescription() {
        return this.attributeDescription;
    }

    public void setAttributeDescription(LdapString attributeDescription) {
        this.attributeDescription = attributeDescription;
    }

    public int computeLength() {
        return 1 + Length.getNbBytes((int)this.attributeDescription.getNbBytes()) + this.attributeDescription.getNbBytes();
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)-121);
            buffer.put(Length.getBytes((int)this.attributeDescription.getNbBytes()));
            buffer.put(this.attributeDescription.getBytes());
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        super.encode(buffer);
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.attributeDescription.toString()).append("=*");
        return sb.toString();
    }
}

