/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo.filters;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.ldap.pojo.filters.Filter;

public class SubstringFilter
extends Filter {
    private LdapString type;
    private transient int substringsLength;
    private LdapString initialSubstrings;
    private ArrayList anySubstrings = new ArrayList(1);
    private LdapString finalSubstrings;
    private transient int substringsFilterLength;
    private transient int substringsFilterSequenceLength;

    public ArrayList getAnySubstrings() {
        return this.anySubstrings;
    }

    public void addAnySubstrings(LdapString anySubstrings) {
        this.anySubstrings.add(anySubstrings);
    }

    public LdapString getFinalSubstrings() {
        return this.finalSubstrings;
    }

    public void setFinalSubstrings(LdapString finalSubstrings) {
        this.finalSubstrings = finalSubstrings;
    }

    public LdapString getInitialSubstrings() {
        return this.initialSubstrings;
    }

    public void setInitialSubstrings(LdapString initialSubstrings) {
        this.initialSubstrings = initialSubstrings;
    }

    public LdapString getType() {
        return this.type;
    }

    public void setType(LdapString type) {
        this.type = type;
    }

    public int getSubstringsLength() {
        return this.substringsLength;
    }

    public void setSubstringsLength(int substringsLength) {
        this.substringsLength = substringsLength;
    }

    public int computeLength() {
        this.substringsFilterLength = 1 + Length.getNbBytes((int)this.type.getNbBytes()) + this.type.getNbBytes();
        this.substringsFilterSequenceLength = 0;
        if (this.initialSubstrings != null) {
            this.substringsFilterSequenceLength += 1 + Length.getNbBytes((int)this.initialSubstrings.getNbBytes()) + this.initialSubstrings.getNbBytes();
        }
        if (this.anySubstrings != null) {
            Iterator anyIterator = this.anySubstrings.iterator();
            while (anyIterator.hasNext()) {
                LdapString any = (LdapString)anyIterator.next();
                this.substringsFilterSequenceLength += 1 + Length.getNbBytes((int)any.getNbBytes()) + any.getNbBytes();
            }
        }
        if (this.finalSubstrings != null) {
            this.substringsFilterSequenceLength += 1 + Length.getNbBytes((int)this.finalSubstrings.getNbBytes()) + this.finalSubstrings.getNbBytes();
        }
        this.substringsFilterLength += 1 + Length.getNbBytes((int)this.substringsFilterSequenceLength) + this.substringsFilterSequenceLength;
        return 1 + Length.getNbBytes((int)this.substringsFilterLength) + this.substringsFilterLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)-92);
            buffer.put(Length.getBytes((int)this.substringsFilterLength));
            Value.encode((ByteBuffer)buffer, (byte[])this.type.getBytes());
            buffer.put((byte)48);
            buffer.put(Length.getBytes((int)this.substringsFilterSequenceLength));
            if (this.initialSubstrings == null && (this.anySubstrings == null || this.anySubstrings.size() == 0) && this.finalSubstrings == null) {
                throw new EncoderException("Cannot have a null initial, any and final substring");
            }
            if (this.initialSubstrings != null) {
                buffer.put((byte)-128);
                buffer.put(Length.getBytes((int)this.initialSubstrings.getNbBytes()));
                buffer.put(this.initialSubstrings.getBytes());
            }
            if (this.anySubstrings != null) {
                Iterator anyIterator = this.anySubstrings.iterator();
                while (anyIterator.hasNext()) {
                    LdapString any = (LdapString)anyIterator.next();
                    buffer.put((byte)-127);
                    buffer.put(Length.getBytes((int)any.getNbBytes()));
                    buffer.put(any.getBytes());
                }
            }
            if (this.finalSubstrings != null) {
                buffer.put((byte)-126);
                buffer.put(Length.getBytes((int)this.finalSubstrings.getNbBytes()));
                buffer.put(this.finalSubstrings.getBytes());
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.initialSubstrings != null) {
            sb.append(this.initialSubstrings.toString());
        }
        sb.append('*');
        if (this.anySubstrings != null) {
            Iterator anyIterator = this.anySubstrings.iterator();
            while (anyIterator.hasNext()) {
                sb.append((LdapString)anyIterator.next()).append('*');
            }
        }
        if (this.finalSubstrings != null) {
            sb.append(this.finalSubstrings.toString());
        }
        return sb.toString();
    }
}

