/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.crypto.encryption;

import org.apache.kerberos.crypto.encryption.Des3CbcMd5Encryption;
import org.apache.kerberos.crypto.encryption.Des3CbcSha1Encryption;
import org.apache.kerberos.crypto.encryption.DesCbcCrcEncryption;
import org.apache.kerberos.crypto.encryption.DesCbcMd4Encryption;
import org.apache.kerberos.crypto.encryption.DesCbcMd5Encryption;
import org.apache.kerberos.crypto.encryption.EncryptionEngine;
import org.apache.kerberos.crypto.encryption.NullEncryption;
import org.apache.kerberos.exceptions.ErrorType;
import org.apache.kerberos.exceptions.KerberosException;
import org.apache.kerberos.messages.value.EncryptionKey;

public class EncryptionEngineFactory {
    public static EncryptionEngine getEncryptionEngineFor(EncryptionKey key) throws KerberosException {
        int type = key.getKeyType().getOrdinal();
        switch (type) {
            case 0: {
                return new NullEncryption();
            }
            case 1: {
                return new DesCbcCrcEncryption();
            }
            case 2: {
                return new DesCbcMd4Encryption();
            }
            case 3: {
                return new DesCbcMd5Encryption();
            }
            case 5: {
                return new Des3CbcMd5Encryption();
            }
            case 7: {
                return new Des3CbcSha1Encryption();
            }
        }
        throw new KerberosException(ErrorType.KDC_ERR_ETYPE_NOSUPP);
    }
}

