/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.asn1.der.ASN1InputStream;
import org.apache.asn1.der.DERApplicationSpecific;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERGeneralString;
import org.apache.asn1.der.DERGeneralizedTime;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;
import org.apache.kerberos.io.decoder.AuthorizationDataDecoder;
import org.apache.kerberos.io.decoder.ChecksumDecoder;
import org.apache.kerberos.io.decoder.EncryptionKeyDecoder;
import org.apache.kerberos.io.decoder.KerberosTimeDecoder;
import org.apache.kerberos.io.decoder.PrincipalNameDecoder;
import org.apache.kerberos.messages.components.Authenticator;
import org.apache.kerberos.messages.components.AuthenticatorModifier;

public class AuthenticatorDecoder {
    public Authenticator decode(byte[] encodedAuthenticator) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedAuthenticator);
        DERApplicationSpecific app = (DERApplicationSpecific)ais.readObject();
        DERSequence sequence = (DERSequence)app.getObject();
        return AuthenticatorDecoder.decode(sequence);
    }

    protected static Authenticator decode(DERSequence sequence) {
        AuthenticatorModifier modifier = new AuthenticatorModifier();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger tag0 = (DERInteger)derObject;
                    modifier.setVersionNumber(tag0.intValue());
                    break;
                }
                case 1: {
                    DERGeneralString tag1 = (DERGeneralString)derObject;
                    modifier.setClientRealm(tag1.getString());
                    break;
                }
                case 2: {
                    DERSequence tag2 = (DERSequence)derObject;
                    modifier.setClientName(PrincipalNameDecoder.decode(tag2));
                    break;
                }
                case 3: {
                    DERSequence tag3 = (DERSequence)derObject;
                    modifier.setChecksum(ChecksumDecoder.decode(tag3));
                    break;
                }
                case 4: {
                    DERInteger tag4 = (DERInteger)derObject;
                    modifier.setClientMicroSecond(tag4.intValue());
                    break;
                }
                case 5: {
                    DERGeneralizedTime tag5 = (DERGeneralizedTime)derObject;
                    modifier.setClientTime(KerberosTimeDecoder.decode(tag5));
                    break;
                }
                case 6: {
                    DERSequence tag6 = (DERSequence)derObject;
                    modifier.setSubSessionKey(EncryptionKeyDecoder.decode(tag6));
                    break;
                }
                case 7: {
                    DERInteger tag7 = (DERInteger)derObject;
                    modifier.setSequenceNumber(tag7.intValue());
                    break;
                }
                case 8: {
                    DERSequence tag8 = (DERSequence)derObject;
                    modifier.setAuthorizationData(AuthorizationDataDecoder.decodeSequence(tag8));
                }
            }
        }
        return modifier.getAuthenticator();
    }
}

