/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.messages.value;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class AuthorizationType
implements Comparable {
    public static final AuthorizationType NULL = new AuthorizationType(0, "null");
    public static final AuthorizationType IF_RELEVANT = new AuthorizationType(1, "if relevant");
    public static final AuthorizationType INTENDED_FOR_SERVER = new AuthorizationType(2, "intended for server");
    public static final AuthorizationType INTENDED_FOR_APPLICATION_CLASS = new AuthorizationType(3, "intended for application class");
    public static final AuthorizationType KDC_ISSUED = new AuthorizationType(4, "kdc issued");
    public static final AuthorizationType OR = new AuthorizationType(5, "or");
    public static final AuthorizationType MANDATORY_TICKET_EXTENSIONS = new AuthorizationType(6, "mandatory ticket extensions");
    public static final AuthorizationType IN_TICKET_EXTENSIONS = new AuthorizationType(7, "in ticket extensions");
    public static final AuthorizationType OSF_DCE = new AuthorizationType(64, "OSF DCE");
    public static final AuthorizationType SESAME = new AuthorizationType(65, "sesame");
    private final String _fName;
    private final int _fOrdinal;
    private static final AuthorizationType[] fValues = new AuthorizationType[]{NULL, IF_RELEVANT, INTENDED_FOR_SERVER, INTENDED_FOR_APPLICATION_CLASS, KDC_ISSUED, OR, MANDATORY_TICKET_EXTENSIONS, IN_TICKET_EXTENSIONS, OSF_DCE, SESAME};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(fValues));

    public String toString() {
        return this._fName + " (" + this._fOrdinal + ")";
    }

    public int compareTo(Object that) {
        return this._fOrdinal - ((AuthorizationType)that)._fOrdinal;
    }

    public static AuthorizationType getTypeByOrdinal(int type) {
        for (int i = 0; i < fValues.length; ++i) {
            if (AuthorizationType.fValues[i]._fOrdinal != type) continue;
            return fValues[i];
        }
        return NULL;
    }

    public int getOrdinal() {
        return this._fOrdinal;
    }

    private AuthorizationType(int ordinal, String name) {
        this._fOrdinal = ordinal;
        this._fName = name;
    }
}

