/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.store;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.kerberos.crypto.encryption.EncryptionType;
import org.apache.kerberos.messages.value.EncryptionKey;
import org.apache.kerberos.messages.value.KerberosTime;
import org.apache.kerberos.messages.value.SamType;

public class PrincipalStoreEntry {
    private String _commonName;
    private KerberosPrincipal _principal;
    private KerberosTime _validStart;
    private KerberosTime _validEnd;
    private KerberosTime _passwordEnd;
    private int _maxLife;
    private int _maxRenew;
    private int _kdcFlags;
    private SamType samType = null;
    private EncryptionKey _key;
    private String _realmName;

    PrincipalStoreEntry(String commonName, KerberosPrincipal principal, int keyVersionNumber, KerberosTime validStart, KerberosTime validEnd, KerberosTime passwordEnd, int maxLife, int maxRenew, int kdcFlags, int keyType, byte[] key, String realmName, SamType samType) {
        this._commonName = commonName;
        this._principal = principal;
        this._validStart = validStart;
        this._validEnd = validEnd;
        this._passwordEnd = passwordEnd;
        this._maxLife = maxLife;
        this._maxRenew = maxRenew;
        this._kdcFlags = kdcFlags;
        this._realmName = realmName;
        this.samType = samType;
        this._key = new EncryptionKey(EncryptionType.getTypeByOrdinal(keyType), key, keyVersionNumber);
    }

    public String getCommonName() {
        return this._commonName;
    }

    public EncryptionKey getEncryptionKey() {
        return this._key;
    }

    public int getKDCFlags() {
        return this._kdcFlags;
    }

    public int getMaxLife() {
        return this._maxLife;
    }

    public int getMaxRenew() {
        return this._maxRenew;
    }

    public KerberosTime getPasswordEnd() {
        return this._passwordEnd;
    }

    public KerberosPrincipal getPrincipal() {
        return this._principal;
    }

    public String getRealmName() {
        return this._realmName;
    }

    public KerberosTime getValidEnd() {
        return this._validEnd;
    }

    public KerberosTime getValidStart() {
        return this._validStart;
    }

    public SamType getSamType() {
        return this.samType;
    }
}

