/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.store.operations;

import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.kerberos.store.ContextOperation;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.common.util.NestableRuntimeException;

public class ChangePassword
implements ContextOperation {
    protected KerberosPrincipal principal;
    protected KerberosKey newKey;

    public ChangePassword(KerberosPrincipal principal, KerberosKey newKey) {
        this.principal = principal;
        this.newKey = newKey;
    }

    public Object execute(DirContext ctx, Name searchBaseDn) {
        if (this.principal == null) {
            return null;
        }
        ModificationItem[] mods = new ModificationItem[1];
        BasicAttribute newKeyAttribute = new BasicAttribute("krb5key", this.newKey.getEncoded());
        mods[0] = new ModificationItem(2, newKeyAttribute);
        String dn = null;
        try {
            dn = this.search(ctx, searchBaseDn, this.principal.getName());
            Name rdn = this.getRelativeName(ctx, dn);
            ctx.modifyAttributes(rdn, mods);
        }
        catch (NamingException e) {
            e.printStackTrace();
            return null;
        }
        return dn;
    }

    private String search(DirContext ctx, Name searchBaseDn, String principal) throws NamingException {
        SearchResult sr;
        String[] attrIDs = new String[]{"krb5PrincipalName", "krb5KeyVersionNumber", "krb5EncryptionType", "krb5Key"};
        BasicAttributes matchAttrs = new BasicAttributes(false);
        matchAttrs.put(new BasicAttribute("krb5PrincipalName", principal));
        NamingEnumeration<SearchResult> answer = ctx.search(searchBaseDn, (Attributes)matchAttrs, attrIDs);
        if (answer.hasMore() && (sr = answer.next()) != null) {
            return sr.getName();
        }
        return null;
    }

    private Name getRelativeName(DirContext ctx, String baseDn) {
        LdapName searchBaseDn;
        block4: {
            searchBaseDn = null;
            try {
                LdapName ctxRoot = new LdapName(ctx.getNameInNamespace());
                searchBaseDn = new LdapName(baseDn);
                if (searchBaseDn.startsWith((Name)ctxRoot)) {
                    for (int ii = 0; ii < ctxRoot.size(); ++ii) {
                        searchBaseDn.remove(0);
                    }
                    break block4;
                }
                String msg = "Failed to create initial context for ApacheDS provider";
                throw new IllegalArgumentException(msg);
            }
            catch (NamingException e) {
                String msg = "Failed to find search base for ApacheDS store";
                throw new NestableRuntimeException(msg, (Throwable)e);
            }
        }
        return searchBaseDn;
    }
}

