/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.store.operations;

import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.kerberos.messages.value.SamType;
import org.apache.kerberos.store.ContextOperation;
import org.apache.kerberos.store.PrincipalStoreEntry;
import org.apache.kerberos.store.PrincipalStoreEntryModifier;

public class GetPrincipal
implements ContextOperation {
    private final KerberosPrincipal principal;

    public GetPrincipal(KerberosPrincipal principal) {
        this.principal = principal;
    }

    protected KerberosPrincipal getPrincipal() {
        return this.principal;
    }

    public Object execute(DirContext ctx, Name base) {
        if (this.principal == null) {
            return null;
        }
        String[] attrIDs = new String[]{"krb5PrincipalName", "krb5KeyVersionNumber", "krb5EncryptionType", "krb5Key"};
        BasicAttributes matchAttrs = new BasicAttributes(false);
        matchAttrs.put(new BasicAttribute("krb5PrincipalName", this.principal.getName()));
        PrincipalStoreEntry entry = null;
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(base, (Attributes)matchAttrs, attrIDs);
            if (answer.hasMore()) {
                SearchResult result = answer.next();
                Attributes attrs = result.getAttributes();
                if (attrs == null) {
                    return null;
                }
                entry = this.getEntry(attrs);
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
            return null;
        }
        return entry;
    }

    private PrincipalStoreEntry getEntry(Attributes attrs) throws NamingException {
        PrincipalStoreEntryModifier modifier = new PrincipalStoreEntryModifier();
        String principal = (String)attrs.get("krb5PrincipalName").get();
        String encryptionType = (String)attrs.get("krb5EncryptionType").get();
        String keyVersionNumber = (String)attrs.get("krb5KeyVersionNumber").get();
        if (attrs.get("apacheSamType") != null) {
            String samType = (String)attrs.get("apacheSamType").get();
            modifier.setSamType(SamType.getTypeByOrdinal(Integer.parseInt(samType)));
        }
        byte[] keyBytes = (byte[])attrs.get("krb5Key").get();
        modifier.setPrincipal(new KerberosPrincipal(principal));
        modifier.setEncryptionType(Integer.parseInt(encryptionType));
        modifier.setKeyVersionNumber(Integer.parseInt(keyVersionNumber));
        modifier.setKey(keyBytes);
        return modifier.getEntry();
    }
}

