/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc;

import java.math.BigInteger;
import org.apache.ldap.common.NotImplementedException;
import org.apache.ldap.common.berlib.snacc.ControlTransform;
import org.apache.ldap.common.berlib.snacc.Utils;
import org.apache.ldap.common.berlib.snacc.ldap_v3.AuthenticationChoice;
import org.apache.ldap.common.berlib.snacc.ldap_v3.BindRequest;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessage;
import org.apache.ldap.common.message.BindRequestImpl;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.spi.ProviderException;

public class BindRequestTransform {
    public static final BigInteger LDAPV2 = new BigInteger("2");
    public static final BigInteger LDAPV3 = new BigInteger("3");

    static org.apache.ldap.common.message.BindRequest transform(LDAPMessage a_snaccMessage) throws ProviderException {
        BindRequestImpl l_request = new BindRequestImpl(a_snaccMessage.messageID.intValue());
        ControlTransform.transformFromSnacc((Message)l_request, a_snaccMessage.controls);
        if (a_snaccMessage.protocolOp.bindRequest.version.equals(LDAPV3)) {
            l_request.setVersion3(true);
        } else {
            l_request.setVersion3(false);
        }
        if (a_snaccMessage.protocolOp.bindRequest.authentication.choiceId != Integer.MIN_VALUE) {
            throw new NotImplementedException("The SASL Authentication Mechanism not implemented yet!");
        }
        l_request.setSimple(true);
        byte[] l_dn = a_snaccMessage.protocolOp.bindRequest.name;
        if (l_dn == null) {
            l_request.setName("");
        } else {
            l_request.setName(new String(l_dn));
        }
        byte[] l_credentials = a_snaccMessage.protocolOp.bindRequest.authentication.simple;
        if (l_credentials == null) {
            l_credentials = new byte[]{};
        }
        l_request.setCredentials(l_credentials);
        return l_request;
    }

    static LDAPMessage transform(org.apache.ldap.common.message.BindRequest a_req) {
        LDAPMessage l_message = Utils.prepareEnvelope((Message)a_req);
        BindRequest l_request = new BindRequest();
        AuthenticationChoice l_authChoice = new AuthenticationChoice();
        l_message.protocolOp.choiceId = 0x40000000;
        l_message.protocolOp.bindRequest = l_request;
        l_request.name = a_req.getName().getBytes();
        l_request.authentication = l_authChoice;
        if (!a_req.isSimple()) {
            l_authChoice.choiceId = -2147483645;
            throw new NotImplementedException("SASL authentication has not been implemented yet!");
        }
        l_authChoice.choiceId = Integer.MIN_VALUE;
        l_authChoice.simple = a_req.getCredentials();
        l_request.version = a_req.isVersion3() ? LDAPV3 : LDAPV2;
        return l_message;
    }
}

