/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc;

import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.berlib.snacc.ControlTransform;
import org.apache.ldap.common.berlib.snacc.ReferralTransform;
import org.apache.ldap.common.berlib.snacc.Utils;
import org.apache.ldap.common.berlib.snacc.ldap_v3.ExtendedResponse;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessage;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessageChoice;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPResultEnum;
import org.apache.ldap.common.message.ExtendedResponseImpl;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.LdapResultImpl;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.message.spi.ProviderException;

public class ExtendedResponseTransform {
    static org.apache.ldap.common.message.ExtendedResponse transformFromSnacc(LDAPMessage a_snaccMessage) throws ProviderException {
        byte[] l_dn;
        ExtendedResponseImpl l_response = new ExtendedResponseImpl(a_snaccMessage.messageID.intValue());
        LDAPMessageChoice l_snaccOp = a_snaccMessage.protocolOp;
        ExtendedResponse l_snaccResponse = l_snaccOp.extendedResp;
        LdapResultImpl l_result = new LdapResultImpl((Lockable)l_response);
        ControlTransform.transformFromSnacc((Message)l_response, a_snaccMessage.controls);
        l_response.setLdapResult((LdapResult)l_result);
        l_response.setResponseName(new String(l_snaccResponse.responseName));
        l_response.setResponse(l_snaccResponse.response);
        if (l_snaccResponse.errorMessage != null) {
            l_result.setErrorMessage(new String(l_snaccResponse.errorMessage));
        }
        if (l_snaccResponse.referral != null) {
            ReferralTransform.transformAdd((LdapResult)l_result, l_snaccResponse.referral);
        }
        if ((l_dn = l_snaccResponse.matchedDN) == null) {
            l_result.setMatchedDn("");
        } else {
            l_result.setMatchedDn(new String(l_dn));
        }
        LDAPResultEnum l_snaccCode = l_snaccResponse.resultCode;
        ResultCodeEnum l_resultCode = ResultCodeEnum.getResultCodeEnum((int)l_snaccCode.value);
        l_result.setResultCode(l_resultCode);
        return l_response;
    }

    static LDAPMessage transformToSnacc(org.apache.ldap.common.message.ExtendedResponse a_resp) {
        LDAPResultEnum l_snaccResultEnum;
        ExtendedResponse l_snaccResponse;
        LDAPMessage l_snaccMessage = Utils.prepareEnvelope((Message)a_resp);
        LDAPMessageChoice l_snaccOp = l_snaccMessage.protocolOp;
        l_snaccOp.choiceId = 1073741848;
        LdapResult l_result = a_resp.getLdapResult();
        l_snaccOp.extendedResp = l_snaccResponse = new ExtendedResponse();
        l_snaccResponse.responseName = a_resp.getResponseName().getBytes();
        l_snaccResponse.response = a_resp.getResponse();
        l_snaccResponse.resultCode = l_snaccResultEnum = new LDAPResultEnum();
        l_snaccResultEnum.value = l_result.getResultCode().getValue();
        l_snaccResponse.errorMessage = l_result.getErrorMessage() == null ? "".getBytes() : l_result.getErrorMessage().getBytes();
        l_snaccResponse.matchedDN = l_result.getMatchedDn().toString().getBytes();
        l_snaccResponse.referral = ReferralTransform.transform(l_result.getReferral());
        return l_snaccMessage;
    }
}

