/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc;

import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.ldap.common.berlib.snacc.SnaccProvider;
import org.apache.ldap.common.berlib.snacc.ldap_v3.AttributeValueAssertion;
import org.apache.ldap.common.berlib.snacc.ldap_v3.Filter;
import org.apache.ldap.common.berlib.snacc.ldap_v3.FilterSetOf;
import org.apache.ldap.common.berlib.snacc.ldap_v3.FilterSetOf1;
import org.apache.ldap.common.berlib.snacc.ldap_v3.MatchingRuleAssertion;
import org.apache.ldap.common.berlib.snacc.ldap_v3.SubstringFilter;
import org.apache.ldap.common.berlib.snacc.ldap_v3.SubstringFilterSeqOf;
import org.apache.ldap.common.berlib.snacc.ldap_v3.SubstringFilterSeqOfChoice;
import org.apache.ldap.common.filter.BranchNode;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.ExtensibleNode;
import org.apache.ldap.common.filter.LeafNode;
import org.apache.ldap.common.filter.PresenceNode;
import org.apache.ldap.common.filter.SimpleNode;
import org.apache.ldap.common.filter.SubstringNode;
import org.apache.ldap.common.message.spi.ProviderException;

public class FilterTransform {
    public static ExprNode transformFromSnacc(Filter a_filter) {
        switch (a_filter.choiceId) {
            case -2147483648: {
                FilterSetOf l_and = a_filter.and;
                BranchNode l_bn = new BranchNode(10);
                Enumeration l_filters = l_and.elements();
                while (l_filters.hasMoreElements()) {
                    l_bn.getChildren().add(FilterTransform.transformFromSnacc((Filter)l_filters.nextElement()));
                }
                return l_bn;
            }
            case -2147483646: {
                BranchNode l_bn = new BranchNode(11);
                l_bn.getChildren().add(FilterTransform.transformFromSnacc(a_filter.not));
                return l_bn;
            }
            case -2147483647: {
                FilterSetOf1 l_or = a_filter.or;
                BranchNode l_bn = new BranchNode(9);
                Enumeration l_filters = l_or.elements();
                while (l_filters.hasMoreElements()) {
                    l_bn.getChildren().add(FilterTransform.transformFromSnacc((Filter)l_filters.nextElement()));
                }
                return l_bn;
            }
            case -2147483640: {
                AttributeValueAssertion l_approxAva = a_filter.approxMatch;
                String l_attr = new String(l_approxAva.attributeDesc);
                String l_value = new String(l_approxAva.assertionValue);
                SimpleNode l_ava = new SimpleNode(l_attr, l_value, 5);
                return l_ava;
            }
            case -2147483645: {
                AttributeValueAssertion l_equalityAva = a_filter.equalityMatch;
                String l_attr = new String(l_equalityAva.attributeDesc);
                String l_value = new String(l_equalityAva.assertionValue);
                SimpleNode l_ava = new SimpleNode(l_attr, l_value, 0);
                return l_ava;
            }
            case -2147483639: {
                MatchingRuleAssertion l_snaccMra = a_filter.extensibleMatch;
                String l_attr = new String(l_snaccMra.type);
                String l_value = new String(l_snaccMra.matchValue);
                String l_matchingRule = new String(l_snaccMra.matchingRule);
                boolean dnAttributes = l_snaccMra.dnAttributes;
                ExtensibleNode l_en = new ExtensibleNode(l_attr, l_value, l_matchingRule, dnAttributes);
                return l_en;
            }
            case -2147483643: {
                AttributeValueAssertion l_greaterOrEqualAva = a_filter.greaterOrEqual;
                String l_attr = new String(l_greaterOrEqualAva.attributeDesc);
                String l_value = new String(l_greaterOrEqualAva.assertionValue);
                SimpleNode l_ava = new SimpleNode(l_attr, l_value, 3);
                return l_ava;
            }
            case -2147483642: {
                AttributeValueAssertion l_lessOrEqualAva = a_filter.lessOrEqual;
                String l_attr = new String(l_lessOrEqualAva.attributeDesc);
                String l_value = new String(l_lessOrEqualAva.assertionValue);
                SimpleNode l_ava = new SimpleNode(l_attr, l_value, 4);
                return l_ava;
            }
            case -2147483641: {
                PresenceNode l_pn = new PresenceNode(new String(a_filter.present));
                return l_pn;
            }
            case -2147483644: {
                SubstringFilter l_subStrFilter = a_filter.substrings;
                String l_initial = null;
                String l_final = null;
                String l_attr = new String(l_subStrFilter.type);
                SubstringFilterSeqOf l_subfilters = l_subStrFilter.substrings;
                Enumeration l_substrings = l_subfilters.elements();
                ArrayList<String> l_any = new ArrayList<String>(2);
                SubstringFilterSeqOfChoice l_element = null;
                while (l_substrings.hasMoreElements()) {
                    l_element = (SubstringFilterSeqOfChoice)l_substrings.nextElement();
                    if (-2147483647 == l_element.choiceId) {
                        l_any.add(new String(l_element.any));
                        continue;
                    }
                    if (Integer.MIN_VALUE == l_element.choiceId) {
                        l_initial = new String(l_element.initial);
                        continue;
                    }
                    if (-2147483646 == l_element.choiceId) {
                        l_final = new String(l_element.final1);
                        continue;
                    }
                    throw new IllegalArgumentException("Undefined substring filter sequence choice:\n" + l_element + " in filter " + a_filter);
                }
                SubstringNode l_sn = new SubstringNode(l_any, l_attr, l_initial, l_final);
                return l_sn;
            }
        }
        throw new IllegalArgumentException("Undefined choice id for filter expression:\n" + a_filter);
    }

    public static Filter transformToSnacc(ExprNode a_rootNode) throws ProviderException {
        Filter l_snaccFilter = new Filter();
        FilterTransform.transformToSnacc(a_rootNode, l_snaccFilter);
        return l_snaccFilter;
    }

    private static SubstringFilter getSubstringFilter(SubstringNode a_node) {
        SubstringFilterSeqOf l_seq;
        SubstringFilter l_subStrFilter = new SubstringFilter();
        l_subStrFilter.type = a_node.getAttribute().getBytes();
        l_subStrFilter.substrings = l_seq = new SubstringFilterSeqOf();
        SubstringFilterSeqOfChoice l_initial = new SubstringFilterSeqOfChoice();
        l_initial.choiceId = Integer.MIN_VALUE;
        l_initial.initial = a_node.getInitial().getBytes();
        l_seq.add(l_initial);
        for (int ii = 0; ii < a_node.getAny().size(); ++ii) {
            SubstringFilterSeqOfChoice l_any = new SubstringFilterSeqOfChoice();
            l_any.choiceId = -2147483647;
            l_any.any = ((String)a_node.getAny().get(ii)).getBytes();
            l_seq.add(l_any);
        }
        SubstringFilterSeqOfChoice l_final = new SubstringFilterSeqOfChoice();
        l_final.choiceId = -2147483646;
        l_final.final1 = a_node.getFinal().getBytes();
        l_seq.add(l_final);
        return l_subStrFilter;
    }

    private static MatchingRuleAssertion getMra(ExtensibleNode a_node) {
        MatchingRuleAssertion l_mra = new MatchingRuleAssertion();
        l_mra.type = a_node.getAttribute().getBytes();
        l_mra.matchValue = a_node.getValue().getBytes();
        l_mra.matchingRule = a_node.getMatchingRuleId().getBytes();
        l_mra.dnAttributes = a_node.dnAttributes();
        return l_mra;
    }

    private static AttributeValueAssertion getAva(SimpleNode a_node) throws ProviderException {
        AttributeValueAssertion l_ava = new AttributeValueAssertion();
        l_ava.attributeDesc = a_node.getAttribute().getBytes();
        l_ava.assertionValue = a_node.getValue().getBytes();
        return l_ava;
    }

    private static void transformToSnacc(ExprNode a_node, Filter a_filter) throws ProviderException {
        if (a_node.isLeaf()) {
            LeafNode l_leaf = (LeafNode)a_node;
            switch (l_leaf.getAssertionType()) {
                case 5: {
                    a_filter.choiceId = -2147483640;
                    a_filter.approxMatch = FilterTransform.getAva((SimpleNode)a_node);
                    break;
                }
                case 0: {
                    a_filter.choiceId = -2147483645;
                    a_filter.equalityMatch = FilterTransform.getAva((SimpleNode)a_node);
                    break;
                }
                case 6: {
                    a_filter.choiceId = -2147483639;
                    a_filter.extensibleMatch = FilterTransform.getMra((ExtensibleNode)a_node);
                    break;
                }
                case 3: {
                    a_filter.choiceId = -2147483643;
                    a_filter.greaterOrEqual = FilterTransform.getAva((SimpleNode)a_node);
                    break;
                }
                case 4: {
                    a_filter.choiceId = -2147483642;
                    a_filter.lessOrEqual = FilterTransform.getAva((SimpleNode)a_node);
                    break;
                }
                case 1: {
                    a_filter.choiceId = -2147483641;
                    a_filter.present = ((PresenceNode)a_node).getAttribute().getBytes();
                    break;
                }
                case 2: {
                    a_filter.choiceId = -2147483644;
                    a_filter.substrings = FilterTransform.getSubstringFilter((SubstringNode)a_node);
                    break;
                }
                case 7: {
                    throw new ProviderException(SnaccProvider.getProvider(), "Scope should not be factored into filter expressions!");
                }
                default: {
                    throw new ProviderException(SnaccProvider.getProvider(), "Unknown leaf node assertion type value: " + l_leaf.getAssertionType());
                }
            }
        } else {
            BranchNode l_branchNode = (BranchNode)a_node;
            switch (l_branchNode.getOperator()) {
                case 9: {
                    a_filter.choiceId = -2147483647;
                    a_filter.or = FilterTransform.getOrExpression(l_branchNode);
                    break;
                }
                case 10: {
                    a_filter.choiceId = Integer.MIN_VALUE;
                    a_filter.and = FilterTransform.getAndExpression(l_branchNode);
                    break;
                }
                case 11: {
                    a_filter.choiceId = -2147483646;
                    a_filter.not = new Filter();
                    FilterTransform.transformToSnacc((ExprNode)l_branchNode.getChildren().get(0), a_filter.not);
                    break;
                }
                default: {
                    throw new ProviderException(SnaccProvider.getProvider(), "Unknown brach node operator value: " + l_branchNode.getOperator());
                }
            }
        }
    }

    private static FilterSetOf1 getOrExpression(BranchNode a_node) {
        if (a_node.getOperator() != 9) {
            throw new ProviderException(SnaccProvider.getProvider(), "Attempting to create an OR expression from another type of BranchNode");
        }
        FilterSetOf1 l_filters = new FilterSetOf1();
        ArrayList l_children = a_node.getChildren();
        for (int ii = 0; ii < l_children.size(); ++ii) {
            Filter l_filter = new Filter();
            ExprNode l_node = (ExprNode)l_children.get(ii);
            FilterTransform.transformToSnacc(l_node, l_filter);
            l_filters.put(l_filter, l_filter);
        }
        return l_filters;
    }

    private static FilterSetOf getAndExpression(BranchNode a_node) {
        if (a_node.getOperator() != 10) {
            throw new ProviderException(SnaccProvider.getProvider(), "Attempting to create an AND expression from another type of BranchNode");
        }
        FilterSetOf l_filters = new FilterSetOf();
        ArrayList l_children = a_node.getChildren();
        for (int ii = 0; ii < l_children.size(); ++ii) {
            Filter l_filter = new Filter();
            ExprNode l_node = (ExprNode)l_children.get(ii);
            FilterTransform.transformToSnacc(l_node, l_filter);
            l_filters.put(l_filter, l_filter);
        }
        return l_filters;
    }
}

