/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;

public class AttributeSetOf
extends Hashtable
implements LDAP_V3 {
    public AttributeSetOf() {
    }

    public AttributeSetOf(AttributeSetOf arg) {
        Enumeration e = arg.elements();
        while (e.hasMoreElements()) {
            byte[] tmp = (byte[])e.nextElement();
            this.put(tmp, tmp);
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int set_of_nr = enc.encodeSetOf();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            enc.encodeOctetString((byte[])e.nextElement());
        }
        enc.endOf(set_of_nr);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int set_of_nr = dec.decodeSetOf();
        while (!dec.endOf(set_of_nr)) {
            byte[] tmp = dec.decodeOctetString();
            this.put(tmp, tmp);
        }
    }

    public void print(PrintStream os, int indent) {
        boolean nonePrinted = true;
        os.println("{ -- SET OF --");
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            if (!nonePrinted) {
                os.println(',');
            }
            nonePrinted = false;
            for (int ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print(Hex.toString((byte[])((byte[])e.nextElement())));
            if (e.hasMoreElements()) continue;
            os.println();
        }
        for (int ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

