/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import org.apache.ldap.common.berlib.snacc.ldap_v3.Controls;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessageChoice;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;

public class LDAPMessage
implements LDAP_V3 {
    public BigInteger messageID;
    public LDAPMessageChoice protocolOp = new LDAPMessageChoice();
    public Controls controls = null;

    public LDAPMessage() {
    }

    public LDAPMessage(LDAPMessage arg) {
        this.messageID = arg.messageID;
        this.protocolOp = new LDAPMessageChoice(arg.protocolOp);
        if (arg.controls != null) {
            this.controls = new Controls(arg.controls);
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq_nr = enc.encodeSequence();
        enc.encodeInteger(this.messageID);
        this.protocolOp.encode(enc);
        if (this.controls != null) {
            enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)0));
            this.controls.encode(enc);
        }
        enc.endOf(seq_nr);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq_nr = dec.decodeSequence();
        this.messageID = dec.decodeInteger();
        this.protocolOp.decode(dec);
        if (!dec.nextIsOptional(ASN1Decoder.makeTag((int)2, (int)0))) {
            this.controls = new Controls();
            dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)0));
            this.controls.decode(dec);
        }
        dec.endOf(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("messageID = ");
        os.print(this.messageID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("protocolOp = ");
        this.protocolOp.print(os, indent + 2);
        os.println(',');
        if (this.controls != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("controls = ");
            this.controls.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

