/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc;

import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.berlib.snacc.ReferralTransform;
import org.apache.ldap.common.berlib.snacc.Utils;
import org.apache.ldap.common.berlib.snacc.ldap_v3.BindResponse;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessage;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessageChoice;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPResultEnum;
import org.apache.ldap.common.message.BindResponseImpl;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.LdapResultImpl;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.message.spi.ProviderException;

public class BindResponseTransform {
    static org.apache.ldap.common.message.BindResponse transform(LDAPMessage a_snaccMessage) throws ProviderException {
        byte[] l_dn;
        BindResponseImpl l_response = new BindResponseImpl(a_snaccMessage.messageID.intValue());
        LdapResultImpl l_result = new LdapResultImpl((Lockable)l_response);
        LDAPMessageChoice l_snaccOp = a_snaccMessage.protocolOp;
        BindResponse l_snaccResponse = l_snaccOp.bindResponse;
        l_response.setLdapResult((LdapResult)l_result);
        if (l_snaccResponse.errorMessage != null) {
            l_result.setErrorMessage(new String(l_snaccResponse.errorMessage));
        }
        if (l_snaccResponse.referral != null) {
            ReferralTransform.transformAdd((LdapResult)l_result, l_snaccResponse.referral);
        }
        if ((l_dn = l_snaccResponse.matchedDN) == null) {
            l_result.setMatchedDn("");
        } else {
            l_result.setMatchedDn(new String(l_dn));
        }
        LDAPResultEnum l_snaccCode = l_snaccResponse.resultCode;
        ResultCodeEnum l_resultCode = ResultCodeEnum.getResultCodeEnum((int)l_snaccCode.value);
        l_result.setResultCode(l_resultCode);
        return l_response;
    }

    static LDAPMessage transform(org.apache.ldap.common.message.BindResponse a_resp) {
        LDAPResultEnum l_snaccResultEnum;
        BindResponse l_snaccResponse;
        LDAPMessage l_snaccMessage = Utils.prepareEnvelope((Message)a_resp);
        LdapResult l_result = a_resp.getLdapResult();
        LDAPMessageChoice l_snaccOp = l_snaccMessage.protocolOp;
        l_snaccOp.choiceId = 0x40000001;
        l_snaccOp.bindResponse = l_snaccResponse = new BindResponse();
        l_snaccResponse.resultCode = l_snaccResultEnum = new LDAPResultEnum();
        ResultCodeEnum l_resultCode = l_result.getResultCode();
        l_snaccResultEnum.value = l_resultCode.getValue();
        l_snaccResponse.errorMessage = l_result.getErrorMessage() == null ? "".getBytes() : l_result.getErrorMessage().getBytes();
        l_snaccResponse.matchedDN = l_result.getMatchedDn().toString().getBytes();
        l_snaccResponse.referral = ReferralTransform.transform(l_result.getReferral());
        if (a_resp.getServerSaslCreds() != null) {
            l_snaccResponse.serverSaslCreds = a_resp.getServerSaslCreds();
        }
        return l_snaccMessage;
    }
}

