/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc;

import java.math.BigInteger;
import java.util.Iterator;
import org.apache.ldap.common.berlib.snacc.ControlTransform;
import org.apache.ldap.common.berlib.snacc.FilterTransform;
import org.apache.ldap.common.berlib.snacc.SnaccProvider;
import org.apache.ldap.common.berlib.snacc.Utils;
import org.apache.ldap.common.berlib.snacc.ldap_v3.AttributeDescriptionList;
import org.apache.ldap.common.berlib.snacc.ldap_v3.Controls;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessage;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessageChoice;
import org.apache.ldap.common.berlib.snacc.ldap_v3.SearchRequest;
import org.apache.ldap.common.berlib.snacc.ldap_v3.SearchRequestEnum;
import org.apache.ldap.common.berlib.snacc.ldap_v3.SearchRequestEnum1;
import org.apache.ldap.common.message.DerefAliasesEnum;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.ScopeEnum;
import org.apache.ldap.common.message.SearchRequestImpl;
import org.apache.ldap.common.message.spi.ProviderException;

public class SearchRequestTransform {
    static org.apache.ldap.common.message.SearchRequest transformFromSnacc(LDAPMessage a_snaccMessage) throws ProviderException {
        SearchRequestImpl l_request = new SearchRequestImpl(a_snaccMessage.messageID.intValue());
        Controls l_snaccControls = a_snaccMessage.controls;
        ControlTransform.transformFromSnacc((Message)l_request, l_snaccControls);
        LDAPMessageChoice l_protocolOp = a_snaccMessage.protocolOp;
        SearchRequest l_snaccRequest = l_protocolOp.searchRequest;
        l_request.setBase(new String(l_snaccRequest.baseObject));
        l_request.setTimeLimit(l_snaccRequest.timeLimit.intValue());
        l_request.setSizeLimit(l_snaccRequest.sizeLimit.intValue());
        l_request.setTypesOnly(l_snaccRequest.typesOnly);
        SearchRequestEnum l_snaccScope = l_snaccRequest.scope;
        switch (l_snaccScope.value) {
            case 0: {
                l_request.setScope(ScopeEnum.BASEOBJECT);
                break;
            }
            case 1: {
                l_request.setScope(ScopeEnum.SINGLELEVEL);
                break;
            }
            case 2: {
                l_request.setScope(ScopeEnum.WHOLESUBTREE);
                break;
            }
            default: {
                throw new ProviderException(SnaccProvider.getProvider(), "Unrecognized snacc scope enumeration value!");
            }
        }
        SearchRequestEnum1 l_derefAliases = l_snaccRequest.derefAliases;
        switch (l_derefAliases.value) {
            case 3: {
                l_request.setDerefAliases(DerefAliasesEnum.DEREFALWAYS);
                break;
            }
            case 2: {
                l_request.setDerefAliases(DerefAliasesEnum.DEREFFINDINGBASEOBJ);
                break;
            }
            case 1: {
                l_request.setDerefAliases(DerefAliasesEnum.DEREFINSEARCHING);
                break;
            }
            case 0: {
                l_request.setDerefAliases(DerefAliasesEnum.NEVERDEREFALIASES);
                break;
            }
            default: {
                throw new ProviderException(SnaccProvider.getProvider(), "Unrecognized snacc derefAliases enumeration value!");
            }
        }
        AttributeDescriptionList l_snaccAttrs = l_snaccRequest.attributes;
        Iterator l_attrList = l_snaccAttrs.iterator();
        while (l_attrList.hasNext()) {
            l_request.addAttribute(new String((byte[])l_attrList.next()));
        }
        l_request.setFilter(FilterTransform.transformFromSnacc(l_snaccRequest.filter));
        return l_request;
    }

    static LDAPMessage transformToSnacc(org.apache.ldap.common.message.SearchRequest a_request) throws ProviderException {
        SearchRequest l_snaccRequest;
        LDAPMessage l_snaccMessage = Utils.prepareEnvelope((Message)a_request);
        LDAPMessageChoice l_protocolOp = l_snaccMessage.protocolOp;
        l_protocolOp.choiceId = 0x40000003;
        l_protocolOp.searchRequest = l_snaccRequest = new SearchRequest();
        l_snaccRequest.baseObject = a_request.getBase().getBytes();
        l_snaccRequest.timeLimit = new BigInteger(Integer.toString(a_request.getTimeLimit()));
        l_snaccRequest.sizeLimit = new BigInteger(Integer.toString(a_request.getSizeLimit()));
        l_snaccRequest.typesOnly = a_request.getTypesOnly();
        SearchRequestEnum l_scope = new SearchRequestEnum();
        switch (a_request.getScope().getValue()) {
            case 0: {
                l_scope.value = 0;
                break;
            }
            case 1: {
                l_scope.value = 1;
                break;
            }
            case 2: {
                l_scope.value = 2;
                break;
            }
            default: {
                throw new ProviderException(SnaccProvider.getProvider(), "Unrecognized search scope parameter value: " + a_request.getScope().getValue());
            }
        }
        l_snaccRequest.scope = l_scope;
        SearchRequestEnum1 l_derefAliases = new SearchRequestEnum1();
        switch (a_request.getDerefAliases().getValue()) {
            case 3: {
                l_derefAliases.value = 3;
                break;
            }
            case 2: {
                l_derefAliases.value = 2;
                break;
            }
            case 1: {
                l_derefAliases.value = 1;
                break;
            }
            case 0: {
                l_derefAliases.value = 0;
                break;
            }
            default: {
                throw new ProviderException(SnaccProvider.getProvider(), "Unrecognized search derefAliases parameter value: " + a_request.getDerefAliases().getValue());
            }
        }
        l_snaccRequest.derefAliases = l_derefAliases;
        AttributeDescriptionList l_snaccAttrList = new AttributeDescriptionList();
        Iterator l_list = a_request.getAttributes().iterator();
        while (l_list.hasNext()) {
            l_snaccAttrList.add(((String)l_list.next()).getBytes());
        }
        l_snaccRequest.attributes = l_snaccAttrList;
        l_snaccRequest.filter = FilterTransform.transformToSnacc(a_request.getFilter());
        return l_snaccMessage;
    }
}

