/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc;

import java.util.Iterator;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.berlib.snacc.ControlTransform;
import org.apache.ldap.common.berlib.snacc.Utils;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessage;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessageChoice;
import org.apache.ldap.common.berlib.snacc.ldap_v3.SearchResultReference;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.Referral;
import org.apache.ldap.common.message.ReferralImpl;
import org.apache.ldap.common.message.SearchResponseReference;
import org.apache.ldap.common.message.SearchResponseReferenceImpl;
import org.apache.ldap.common.message.spi.ProviderException;

public class SearchResponseReferenceTransform {
    static SearchResponseReference transformFromSnacc(LDAPMessage a_snaccMessage) throws ProviderException {
        SearchResponseReferenceImpl l_response = new SearchResponseReferenceImpl(a_snaccMessage.messageID.intValue());
        LDAPMessageChoice l_snaccOp = a_snaccMessage.protocolOp;
        SearchResultReference l_snaccResponse = l_snaccOp.searchResRef;
        ControlTransform.transformFromSnacc((Message)l_response, a_snaccMessage.controls);
        Iterator l_list = l_snaccResponse.iterator();
        ReferralImpl l_referral = new ReferralImpl((Lockable)l_response);
        l_response.setReferral((Referral)l_referral);
        while (l_list.hasNext()) {
            l_referral.addLdapUrl(new String((byte[])l_list.next()));
        }
        return l_response;
    }

    static LDAPMessage transformToSnacc(SearchResponseReference a_resp) throws ProviderException {
        SearchResultReference l_snaccResponse;
        LDAPMessage l_snaccMessage = Utils.prepareEnvelope((Message)a_resp);
        LDAPMessageChoice l_snaccOp = l_snaccMessage.protocolOp;
        l_snaccOp.choiceId = 1073741843;
        l_snaccOp.searchResRef = l_snaccResponse = new SearchResultReference();
        Iterator l_list = a_resp.getReferral().getLdapUrls().iterator();
        while (l_list.hasNext()) {
            l_snaccResponse.add(((String)l_list.next()).getBytes());
        }
        return l_snaccMessage;
    }
}

