/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.asn1.BERDecoder;
import java.io.InputStream;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1.codec.stateful.DecoderCallback;
import org.apache.asn1.codec.stateful.DecoderMonitor;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessage;
import org.apache.ldap.common.message.spi.Provider;
import org.apache.ldap.common.message.spi.ProviderDecoder;
import org.apache.ldap.common.message.spi.ProviderException;

public class SnaccDecoder
implements ProviderDecoder {
    private final Provider m_provider;

    SnaccDecoder(Provider a_provider) {
        this.m_provider = a_provider;
    }

    public Provider getProvider() {
        return this.m_provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(Object a_lock, InputStream a_in) throws ProviderException {
        LDAPMessage l_message = new LDAPMessage();
        BERDecoder l_decoder = new BERDecoder(a_in);
        if (a_lock == null) {
            try {
                l_message.decode((ASN1Decoder)l_decoder);
            }
            catch (ASN1Exception e) {
                ProviderException pe = new ProviderException(this.m_provider, "Snacc decoder failure!");
                pe.addThrowable((Throwable)e);
                throw pe;
            }
            return l_message;
        }
        try {
            Object e = a_lock;
            synchronized (e) {
                l_message.decode((ASN1Decoder)l_decoder);
                a_lock.notifyAll();
            }
        }
        catch (ASN1Exception e) {
            ProviderException pe = new ProviderException(this.m_provider, "Snacc decoder failure!");
            pe.addThrowable((Throwable)e);
            throw pe;
        }
        return l_message;
    }

    public void decode(Object encoded) throws DecoderException {
        throw new UnsupportedOperationException("not supported by provider ");
    }

    public void setCallback(DecoderCallback cb) {
    }

    public void setDecoderMonitor(DecoderMonitor monitor) {
    }
}

