/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;

public class AttributeValueAssertion
implements LDAP_V3 {
    public byte[] attributeDesc;
    public byte[] assertionValue;

    public AttributeValueAssertion() {
    }

    public AttributeValueAssertion(AttributeValueAssertion arg) {
        this.attributeDesc = new byte[arg.attributeDesc.length];
        System.arraycopy(arg.attributeDesc, 0, this.attributeDesc, 0, arg.attributeDesc.length);
        this.assertionValue = new byte[arg.assertionValue.length];
        System.arraycopy(arg.assertionValue, 0, this.assertionValue, 0, arg.assertionValue.length);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.attributeDesc);
        enc.encodeOctetString(this.assertionValue);
        enc.endOf(seq_nr);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq_nr = dec.decodeSequence();
        this.attributeDesc = dec.decodeOctetString();
        this.assertionValue = dec.decodeOctetString();
        dec.endOf(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("attributeDesc = ");
        os.print(Hex.toString((byte[])this.attributeDesc));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("assertionValue = ");
        os.print(Hex.toString((byte[])this.assertionValue));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

