/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import org.apache.ldap.common.berlib.snacc.ldap_v3.AuthenticationChoice;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;

public class BindRequest
implements LDAP_V3 {
    public BigInteger version;
    public byte[] name;
    public AuthenticationChoice authentication = new AuthenticationChoice();

    public BindRequest() {
    }

    public BindRequest(BindRequest arg) {
        this.version = arg.version;
        this.name = new byte[arg.name.length];
        System.arraycopy(arg.name, 0, this.name, 0, arg.name.length);
        this.authentication = new AuthenticationChoice(arg.authentication);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag((int)1, (int)0));
        int seq_nr = enc.encodeSequence();
        enc.encodeInteger(this.version);
        enc.encodeOctetString(this.name);
        this.authentication.encode(enc);
        enc.endOf(seq_nr);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag((int)1, (int)0));
        int seq_nr = dec.decodeSequence();
        this.version = dec.decodeInteger();
        this.name = dec.decodeOctetString();
        this.authentication.decode(dec);
        dec.endOf(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("version = ");
        os.print(this.version.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("name = ");
        os.print(Hex.toString((byte[])this.name));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("authentication = ");
        this.authentication.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

