/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;

public class Control
implements LDAP_V3 {
    public byte[] controlType;
    public boolean criticality = false;
    public byte[] controlValue = null;

    public Control() {
    }

    public Control(Control arg) {
        this.controlType = new byte[arg.controlType.length];
        System.arraycopy(arg.controlType, 0, this.controlType, 0, arg.controlType.length);
        this.criticality = arg.criticality;
        if (arg.controlValue != null) {
            this.controlValue = new byte[arg.controlValue.length];
            System.arraycopy(arg.controlValue, 0, this.controlValue, 0, arg.controlValue.length);
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.controlType);
        if (enc.encodeDefault() || this.criticality) {
            enc.encodeBoolean(this.criticality);
        }
        if (this.controlValue != null) {
            enc.encodeOctetString(this.controlValue);
        }
        enc.endOf(seq_nr);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq_nr = dec.decodeSequence();
        this.controlType = dec.decodeOctetString();
        if (!dec.nextIsDefault(ASN1Decoder.makeTag((int)0, (int)1))) {
            this.criticality = dec.decodeBoolean();
        }
        if (!dec.nextIsOptional(ASN1Decoder.makeTag((int)0, (int)4))) {
            this.controlValue = dec.decodeOctetString();
        }
        dec.endOf(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("controlType = ");
        os.print(Hex.toString((byte[])this.controlType));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("criticality = ");
        os.print(this.criticality);
        os.println(',');
        if (this.controlValue != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("controlValue = ");
            os.print(Hex.toString((byte[])this.controlValue));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

