/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;

public class ExtendedRequest
implements LDAP_V3 {
    public byte[] requestName;
    public byte[] requestValue = null;

    public ExtendedRequest() {
    }

    public ExtendedRequest(ExtendedRequest arg) {
        this.requestName = new byte[arg.requestName.length];
        System.arraycopy(arg.requestName, 0, this.requestName, 0, arg.requestName.length);
        if (arg.requestValue != null) {
            this.requestValue = new byte[arg.requestValue.length];
            System.arraycopy(arg.requestValue, 0, this.requestValue, 0, arg.requestValue.length);
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag((int)1, (int)23));
        int seq_nr = enc.encodeSequence();
        enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)0));
        enc.encodeOctetString(this.requestName);
        if (this.requestValue != null) {
            enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)1));
            enc.encodeOctetString(this.requestValue);
        }
        enc.endOf(seq_nr);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag((int)1, (int)23));
        int seq_nr = dec.decodeSequence();
        dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)0));
        this.requestName = dec.decodeOctetString();
        if (!dec.nextIsOptional(ASN1Decoder.makeTag((int)2, (int)1))) {
            dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)1));
            this.requestValue = dec.decodeOctetString();
        }
        dec.endOf(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("requestName = ");
        os.print(Hex.toString((byte[])this.requestName));
        os.println(',');
        if (this.requestValue != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("requestValue = ");
            os.print(Hex.toString((byte[])this.requestValue));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

