/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;

public class ModifyDNRequest
implements LDAP_V3 {
    public byte[] entry;
    public byte[] newrdn;
    public boolean deleteoldrdn;
    public byte[] newSuperior = null;

    public ModifyDNRequest() {
    }

    public ModifyDNRequest(ModifyDNRequest arg) {
        this.entry = new byte[arg.entry.length];
        System.arraycopy(arg.entry, 0, this.entry, 0, arg.entry.length);
        this.newrdn = new byte[arg.newrdn.length];
        System.arraycopy(arg.newrdn, 0, this.newrdn, 0, arg.newrdn.length);
        this.deleteoldrdn = arg.deleteoldrdn;
        if (arg.newSuperior != null) {
            this.newSuperior = new byte[arg.newSuperior.length];
            System.arraycopy(arg.newSuperior, 0, this.newSuperior, 0, arg.newSuperior.length);
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag((int)1, (int)12));
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.entry);
        enc.encodeOctetString(this.newrdn);
        enc.encodeBoolean(this.deleteoldrdn);
        if (this.newSuperior != null) {
            enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)0));
            enc.encodeOctetString(this.newSuperior);
        }
        enc.endOf(seq_nr);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag((int)1, (int)12));
        int seq_nr = dec.decodeSequence();
        this.entry = dec.decodeOctetString();
        this.newrdn = dec.decodeOctetString();
        this.deleteoldrdn = dec.decodeBoolean();
        if (!dec.nextIsOptional(ASN1Decoder.makeTag((int)2, (int)0))) {
            dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)0));
            this.newSuperior = dec.decodeOctetString();
        }
        dec.endOf(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("entry = ");
        os.print(Hex.toString((byte[])this.entry));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("newrdn = ");
        os.print(Hex.toString((byte[])this.newrdn));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("deleteoldrdn = ");
        os.print(this.deleteoldrdn);
        os.println(',');
        if (this.newSuperior != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("newSuperior = ");
            os.print(Hex.toString((byte[])this.newSuperior));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

