/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.ldap.common.berlib.snacc.ldap_v3.AttributeTypeAndValues;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;
import org.apache.ldap.common.berlib.snacc.ldap_v3.ModifyRequestSeqOfSeqEnum;

public class ModifyRequestSeqOfSeq
implements LDAP_V3 {
    public ModifyRequestSeqOfSeqEnum operation = new ModifyRequestSeqOfSeqEnum();
    public AttributeTypeAndValues modification = new AttributeTypeAndValues();

    public ModifyRequestSeqOfSeq() {
    }

    public ModifyRequestSeqOfSeq(ModifyRequestSeqOfSeq arg) {
        this.operation = new ModifyRequestSeqOfSeqEnum(arg.operation);
        this.modification = new AttributeTypeAndValues(arg.modification);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq_nr = enc.encodeSequence();
        this.operation.encode(enc);
        this.modification.encode(enc);
        enc.endOf(seq_nr);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq_nr = dec.decodeSequence();
        this.operation.decode(dec);
        this.modification.decode(dec);
        dec.endOf(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("operation = ");
        this.operation.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("modification = ");
        this.modification.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

