/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;

public class SaslCredentials
implements LDAP_V3 {
    public byte[] mechanism;
    public byte[] credentials = null;

    public SaslCredentials() {
    }

    public SaslCredentials(SaslCredentials arg) {
        this.mechanism = new byte[arg.mechanism.length];
        System.arraycopy(arg.mechanism, 0, this.mechanism, 0, arg.mechanism.length);
        if (arg.credentials != null) {
            this.credentials = new byte[arg.credentials.length];
            System.arraycopy(arg.credentials, 0, this.credentials, 0, arg.credentials.length);
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.mechanism);
        if (this.credentials != null) {
            enc.encodeOctetString(this.credentials);
        }
        enc.endOf(seq_nr);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq_nr = dec.decodeSequence();
        this.mechanism = dec.decodeOctetString();
        if (!dec.nextIsOptional(ASN1Decoder.makeTag((int)0, (int)4))) {
            this.credentials = dec.decodeOctetString();
        }
        dec.endOf(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("mechanism = ");
        os.print(Hex.toString((byte[])this.mechanism));
        os.println(',');
        if (this.credentials != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("credentials = ");
            os.print(Hex.toString((byte[])this.credentials));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

