/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import org.apache.ldap.common.berlib.snacc.ldap_v3.AttributeDescriptionList;
import org.apache.ldap.common.berlib.snacc.ldap_v3.Filter;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;
import org.apache.ldap.common.berlib.snacc.ldap_v3.SearchRequestEnum;
import org.apache.ldap.common.berlib.snacc.ldap_v3.SearchRequestEnum1;

public class SearchRequest
implements LDAP_V3 {
    public byte[] baseObject;
    public SearchRequestEnum scope = new SearchRequestEnum();
    public SearchRequestEnum1 derefAliases = new SearchRequestEnum1();
    public BigInteger sizeLimit;
    public BigInteger timeLimit;
    public boolean typesOnly;
    public Filter filter = new Filter();
    public AttributeDescriptionList attributes = new AttributeDescriptionList();

    public SearchRequest() {
    }

    public SearchRequest(SearchRequest arg) {
        this.baseObject = new byte[arg.baseObject.length];
        System.arraycopy(arg.baseObject, 0, this.baseObject, 0, arg.baseObject.length);
        this.scope = new SearchRequestEnum(arg.scope);
        this.derefAliases = new SearchRequestEnum1(arg.derefAliases);
        this.sizeLimit = arg.sizeLimit;
        this.timeLimit = arg.timeLimit;
        this.typesOnly = arg.typesOnly;
        this.filter = new Filter(arg.filter);
        this.attributes = new AttributeDescriptionList(arg.attributes);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag((int)1, (int)3));
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.baseObject);
        this.scope.encode(enc);
        this.derefAliases.encode(enc);
        enc.encodeInteger(this.sizeLimit);
        enc.encodeInteger(this.timeLimit);
        enc.encodeBoolean(this.typesOnly);
        this.filter.encode(enc);
        this.attributes.encode(enc);
        enc.endOf(seq_nr);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag((int)1, (int)3));
        int seq_nr = dec.decodeSequence();
        this.baseObject = dec.decodeOctetString();
        this.scope.decode(dec);
        this.derefAliases.decode(dec);
        this.sizeLimit = dec.decodeInteger();
        this.timeLimit = dec.decodeInteger();
        this.typesOnly = dec.decodeBoolean();
        this.filter.decode(dec);
        this.attributes.decode(dec);
        dec.endOf(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("baseObject = ");
        os.print(Hex.toString((byte[])this.baseObject));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("scope = ");
        this.scope.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("derefAliases = ");
        this.derefAliases.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("sizeLimit = ");
        os.print(this.sizeLimit.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("timeLimit = ");
        os.print(this.timeLimit.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("typesOnly = ");
        os.print(this.typesOnly);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("filter = ");
        this.filter.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("attributes = ");
        this.attributes.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

