/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.fishmonger;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.examples.fishmonger.CartItem;

public class ShoppingCart {
    private List items = new ArrayList();
    private double discount = 0.0;

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void addItem(CartItem item) {
        this.items.add(item);
    }

    public List getItems() {
        return this.items;
    }

    public List getItems(String name) {
        ArrayList<CartItem> matching = new ArrayList<CartItem>();
        Iterator itemIter = this.getItems().iterator();
        CartItem eachItem = null;
        while (itemIter.hasNext()) {
            eachItem = (CartItem)itemIter.next();
            if (!eachItem.getName().equals(name)) continue;
            matching.add(eachItem);
        }
        return matching;
    }

    public double getGrossCost() {
        Iterator itemIter = this.getItems().iterator();
        CartItem eachItem = null;
        double cost = 0.0;
        while (itemIter.hasNext()) {
            eachItem = (CartItem)itemIter.next();
            cost += eachItem.getCost();
        }
        return cost;
    }

    public double getDiscountedCost() {
        double cost = this.getGrossCost();
        double discount = this.getDiscount();
        double discountedCost = cost * (1.0 - discount);
        return discountedCost;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ShoppingCart:\n");
        buf.append("\t      gross total=" + this.getGrossCost() + "\n");
        buf.append("\t discounted total=" + this.getDiscountedCost() + "\n");
        Iterator itemIter = this.getItems().iterator();
        while (itemIter.hasNext()) {
            buf.append("\t" + itemIter.next() + "\n");
        }
        buf.append("]");
        return buf.toString();
    }
}

