/*
 * Decompiled with CFR 0.152.
 */
package edu.gemini.grackle;

import cats.implicits$;
import cats.syntax.EitherOps$;
import edu.gemini.grackle.Ast;
import edu.gemini.grackle.Ast$OperationType$Mutation$;
import edu.gemini.grackle.Ast$OperationType$Query$;
import edu.gemini.grackle.Ast$OperationType$Subscription$;
import edu.gemini.grackle.Ast$Value$NullValue$;
import edu.gemini.grackle.GraphQLParser$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.util.Either;

public final class QueryMinimizer$ {
    public static final QueryMinimizer$ MODULE$ = new QueryMinimizer$();

    public Either<String, String> minimizeText(String text) {
        return EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(GraphQLParser$.MODULE$.Document().parseAll(text)), (Function1 & Serializable)x$5 -> x$5.expected().toList().mkString(",")).map((Function1 & Serializable)doc -> MODULE$.minimizeDocument((List<Ast.Definition>)doc));
    }

    public String minimizeDocument(List<Ast.Definition> doc) {
        return doc.map((Function1 & Serializable)defn -> QueryMinimizer$.renderDefinition$1(defn)).mkString(",");
    }

    private static final String renderDefinition$1(Ast.Definition defn) {
        Ast.Definition definition = defn;
        if (definition instanceof Ast.ExecutableDefinition) {
            Ast.ExecutableDefinition executableDefinition = (Ast.ExecutableDefinition)definition;
            return QueryMinimizer$.renderExecutableDefinition$1(executableDefinition);
        }
        return "";
    }

    private static final String renderExecutableDefinition$1(Ast.ExecutableDefinition ex) {
        Ast.ExecutableDefinition executableDefinition = ex;
        if (executableDefinition instanceof Ast.OperationDefinition) {
            Ast.OperationDefinition operationDefinition = (Ast.OperationDefinition)executableDefinition;
            return QueryMinimizer$.renderOperationDefinition$1(operationDefinition);
        }
        if (executableDefinition instanceof Ast.FragmentDefinition) {
            Ast.FragmentDefinition fragmentDefinition = (Ast.FragmentDefinition)executableDefinition;
            return QueryMinimizer$.renderFragmentDefinition$1(fragmentDefinition);
        }
        throw new MatchError((Object)executableDefinition);
    }

    private static final String renderOperationDefinition$1(Ast.OperationDefinition op) {
        Ast.OperationDefinition operationDefinition = op;
        if (operationDefinition instanceof Ast.OperationDefinition.QueryShorthand) {
            Ast.OperationDefinition.QueryShorthand queryShorthand = (Ast.OperationDefinition.QueryShorthand)operationDefinition;
            return QueryMinimizer$.renderSelectionSet$1(queryShorthand.selectionSet());
        }
        if (operationDefinition instanceof Ast.OperationDefinition.Operation) {
            Ast.OperationDefinition.Operation operation = (Ast.OperationDefinition.Operation)operationDefinition;
            return QueryMinimizer$.renderOperation$1(operation);
        }
        throw new MatchError((Object)operationDefinition);
    }

    private static final String renderOperation$1(Ast.OperationDefinition.Operation op) {
        return new StringBuilder(0).append(QueryMinimizer$.renderOperationType$1(op.operationType())).append(op.name().map((Function1 & Serializable)nme -> new StringBuilder(1).append(" ").append(nme.value()).toString()).getOrElse((Function0 & Serializable)() -> "")).append(QueryMinimizer$.renderVariableDefns$1(op.variables())).append(QueryMinimizer$.renderDirectives$1(op.directives())).append(QueryMinimizer$.renderSelectionSet$1(op.selectionSet())).toString();
    }

    private static final String renderOperationType$1(Ast.OperationType op) {
        Ast.OperationType operationType = op;
        if (Ast$OperationType$Query$.MODULE$.equals(operationType)) {
            return "query";
        }
        if (Ast$OperationType$Mutation$.MODULE$.equals(operationType)) {
            return "mutation";
        }
        if (Ast$OperationType$Subscription$.MODULE$.equals(operationType)) {
            return "subscription";
        }
        throw new MatchError((Object)operationType);
    }

    private static final String renderDirectives$1(List dirs) {
        return dirs.map((Function1 & Serializable)x0$1 -> {
            Ast.Directive directive = x0$1;
            if (directive != null) {
                Ast.Name name = directive.name();
                List<Tuple2<Ast.Name, Ast.Value>> args = directive.arguments();
                return new StringBuilder(1).append("@").append(name.value()).append(QueryMinimizer$.renderArguments$1(args)).toString();
            }
            throw new MatchError((Object)directive);
        }).mkString();
    }

    private static final String renderVariableDefns$1(List vars) {
        List list = vars;
        if (Nil$.MODULE$.equals(list)) {
            return "";
        }
        return vars.map((Function1 & Serializable)x0$1 -> {
            Ast.VariableDefinition variableDefinition = x0$1;
            if (variableDefinition != null) {
                Ast.Name name = variableDefinition.name();
                Ast.Type tpe = variableDefinition.tpe();
                Option<Ast.Value> option = variableDefinition.defaultValue();
                return new StringBuilder(2).append("$").append(name.value()).append(":").append(tpe.name()).append(option.map((Function1 & Serializable)v -> new StringBuilder(1).append("=").append(QueryMinimizer$.renderValue$1(v)).toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
            }
            throw new MatchError((Object)variableDefinition);
        }).mkString("(", ",", ")");
    }

    private static final String renderSelectionSet$1(List sels) {
        List list = sels;
        if (Nil$.MODULE$.equals(list)) {
            return "";
        }
        return sels.map((Function1 & Serializable)sel -> QueryMinimizer$.renderSelection$1(sel)).mkString("{", ",", "}");
    }

    private static final String renderSelection$1(Ast.Selection sel) {
        Ast.Selection selection = sel;
        if (selection instanceof Ast.Selection.Field) {
            Ast.Selection.Field field = (Ast.Selection.Field)selection;
            return QueryMinimizer$.renderField$1(field);
        }
        if (selection instanceof Ast.Selection.FragmentSpread) {
            Ast.Selection.FragmentSpread fragmentSpread = (Ast.Selection.FragmentSpread)selection;
            return QueryMinimizer$.renderFragmentSpread$1(fragmentSpread);
        }
        if (selection instanceof Ast.Selection.InlineFragment) {
            Ast.Selection.InlineFragment inlineFragment = (Ast.Selection.InlineFragment)selection;
            return QueryMinimizer$.renderInlineFragment$1(inlineFragment);
        }
        throw new MatchError((Object)selection);
    }

    private static final String renderField$1(Ast.Selection.Field f) {
        return new StringBuilder(0).append((String)f.alias().map((Function1 & Serializable)a -> new StringBuilder(1).append(a.value()).append(":").toString()).getOrElse((Function0 & Serializable)() -> "")).append(f.name().value()).append(QueryMinimizer$.renderArguments$1(f.arguments())).append(QueryMinimizer$.renderDirectives$1(f.directives())).append(QueryMinimizer$.renderSelectionSet$1(f.selectionSet())).toString();
    }

    private static final String renderArguments$1(List args) {
        List list = args;
        if (Nil$.MODULE$.equals(list)) {
            return "";
        }
        return args.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Ast.Name n = (Ast.Name)tuple2._1();
                Ast.Value v = (Ast.Value)tuple2._2();
                return new StringBuilder(1).append(n.value()).append(":").append(QueryMinimizer$.renderValue$1(v)).toString();
            }
            throw new MatchError((Object)tuple2);
        }).mkString("(", ",", ")");
    }

    private static final String renderInputObject$1(List args) {
        List list = args;
        if (Nil$.MODULE$.equals(list)) {
            return "";
        }
        return args.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Ast.Name n = (Ast.Name)tuple2._1();
                Ast.Value v = (Ast.Value)tuple2._2();
                return new StringBuilder(1).append(n.value()).append(":").append(QueryMinimizer$.renderValue$1(v)).toString();
            }
            throw new MatchError((Object)tuple2);
        }).mkString("{", ",", "}");
    }

    private static final String renderTypeCondition$1(Ast.Type tpe) {
        return new StringBuilder(3).append("on ").append(tpe.name()).toString();
    }

    private static final String renderFragmentDefinition$1(Ast.FragmentDefinition frag) {
        return new StringBuilder(10).append("fragment ").append(frag.name().value()).append(" ").append(QueryMinimizer$.renderTypeCondition$1(frag.typeCondition())).append(QueryMinimizer$.renderDirectives$1(frag.directives())).append(QueryMinimizer$.renderSelectionSet$1(frag.selectionSet())).toString();
    }

    private static final String renderFragmentSpread$1(Ast.Selection.FragmentSpread spread) {
        return new StringBuilder(3).append("...").append(spread.name().value()).append(QueryMinimizer$.renderDirectives$1(spread.directives())).toString();
    }

    private static final String renderInlineFragment$1(Ast.Selection.InlineFragment frag) {
        return new StringBuilder(3).append("...").append(frag.typeCondition().map((Function1 & Serializable)tpe -> QueryMinimizer$.renderTypeCondition$1(tpe)).getOrElse((Function0 & Serializable)() -> "")).append(QueryMinimizer$.renderDirectives$1(frag.directives())).append(QueryMinimizer$.renderSelectionSet$1(frag.selectionSet())).toString();
    }

    private static final String renderValue$1(Ast.Value v2) {
        Ast.Value value = v2;
        if (value instanceof Ast.Value.Variable) {
            Ast.Value.Variable variable = (Ast.Value.Variable)value;
            Ast.Name name = variable.name();
            return new StringBuilder(1).append("$").append(name.value()).toString();
        }
        if (value instanceof Ast.Value.IntValue) {
            Ast.Value.IntValue intValue = (Ast.Value.IntValue)value;
            int value2 = intValue.value();
            return Integer.toString(value2);
        }
        if (value instanceof Ast.Value.FloatValue) {
            Ast.Value.FloatValue floatValue = (Ast.Value.FloatValue)value;
            double value3 = floatValue.value();
            return Double.toString(value3);
        }
        if (value instanceof Ast.Value.StringValue) {
            Ast.Value.StringValue stringValue = (Ast.Value.StringValue)value;
            String value4 = stringValue.value();
            return new StringBuilder(2).append("\"").append(value4).append("\"").toString();
        }
        if (value instanceof Ast.Value.BooleanValue) {
            Ast.Value.BooleanValue booleanValue = (Ast.Value.BooleanValue)value;
            boolean value5 = booleanValue.value();
            return Boolean.toString(value5);
        }
        if (Ast$Value$NullValue$.MODULE$.equals(value)) {
            return "null";
        }
        if (value instanceof Ast.Value.EnumValue) {
            Ast.Value.EnumValue enumValue = (Ast.Value.EnumValue)value;
            Ast.Name name = enumValue.name();
            return name.value();
        }
        if (value instanceof Ast.Value.ListValue) {
            Ast.Value.ListValue listValue = (Ast.Value.ListValue)value;
            List<Ast.Value> values = listValue.values();
            return values.map((Function1 & Serializable)v -> QueryMinimizer$.renderValue$1(v)).mkString("[", ",", "]");
        }
        if (value instanceof Ast.Value.ObjectValue) {
            Ast.Value.ObjectValue objectValue = (Ast.Value.ObjectValue)value;
            List<Tuple2<Ast.Name, Ast.Value>> fields = objectValue.fields();
            return QueryMinimizer$.renderInputObject$1(fields);
        }
        throw new MatchError((Object)value);
    }

    private QueryMinimizer$() {
    }
}

