/*
 * Decompiled with CFR 0.152.
 */
package edu.gemini.grackle;

import edu.gemini.grackle.EnumType;
import edu.gemini.grackle.EnumValue;
import edu.gemini.grackle.Field;
import edu.gemini.grackle.InputObjectType;
import edu.gemini.grackle.InputValue;
import edu.gemini.grackle.InterfaceType;
import edu.gemini.grackle.ListType;
import edu.gemini.grackle.NamedType;
import edu.gemini.grackle.NullableType;
import edu.gemini.grackle.ObjectType;
import edu.gemini.grackle.ScalarType;
import edu.gemini.grackle.Schema;
import edu.gemini.grackle.Type;
import edu.gemini.grackle.TypeRef;
import edu.gemini.grackle.UnionType;
import edu.gemini.grackle.Value;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class SchemaRenderer$ {
    public static final SchemaRenderer$ MODULE$ = new SchemaRenderer$();

    public String renderSchema(Schema schema) {
        String string = SchemaRenderer$.mkRootDef$3("query", schema.queryType());
        List fields = ((List)new .colon.colon((Object)schema.mutationType().map((Function1 & Serializable)tpe -> SchemaRenderer$.mkRootDef$3("mutation", tpe)), (List)new .colon.colon((Object)schema.subscriptionType().map((Function1 & Serializable)tpe -> SchemaRenderer$.mkRootDef$3("subscription", tpe)), (List)Nil$.MODULE$)).flatten(Predef$.MODULE$.$conforms())).$colon$colon((Object)string);
        String schemaDefn = fields.sizeCompare(1) == 0 && schema.queryType().$eq$colon$eq(schema.ref("Query")) ? "" : fields.mkString("schema {\n  ", "\n  ", "\n}\n");
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(schemaDefn), schema.types().map((Function1 & Serializable)tpe -> MODULE$.renderTypeDefn((NamedType)tpe)).mkString("\n"));
    }

    public String renderTypeDefn(NamedType tpe) {
        NamedType namedType;
        while ((namedType = tpe) instanceof TypeRef) {
            TypeRef typeRef = (TypeRef)namedType;
            tpe = typeRef.dealias();
        }
        if (namedType instanceof ScalarType) {
            ScalarType scalarType = (ScalarType)namedType;
            String nme = scalarType.name();
            return new StringBuilder(7).append("scalar ").append(nme).toString();
        }
        if (namedType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)namedType;
            String nme = objectType.name();
            List<Field> fields = objectType.fields();
            List<NamedType> ifs0 = objectType.interfaces();
            String ifs = ifs0.isEmpty() ? "" : new StringBuilder(12).append(" implements ").append(ifs0.map((Function1 & Serializable)x$67 -> x$67.name()).mkString("&")).toString();
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(39).append("|type ").append(nme).append(ifs).append(" {\n            |  ").append(fields.map((Function1 & Serializable)f -> this.renderField$1((Field)f)).mkString("\n  ")).append("\n            |}").toString()));
        }
        if (namedType instanceof InterfaceType) {
            InterfaceType interfaceType = (InterfaceType)namedType;
            String nme = interfaceType.name();
            List<Field> fields = interfaceType.fields();
            List<NamedType> ifs0 = interfaceType.interfaces();
            String ifs = ifs0.isEmpty() ? "" : new StringBuilder(12).append(" implements ").append(ifs0.map((Function1 & Serializable)x$68 -> x$68.name()).mkString("&")).toString();
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(44).append("|interface ").append(nme).append(ifs).append(" {\n            |  ").append(fields.map((Function1 & Serializable)f -> this.renderField$1((Field)f)).mkString("\n  ")).append("\n            |}").toString()));
        }
        if (namedType instanceof UnionType) {
            UnionType unionType = (UnionType)namedType;
            String nme = unionType.name();
            List<NamedType> members = unionType.members();
            return new StringBuilder(9).append("union ").append(nme).append(" = ").append(members.map((Function1 & Serializable)x$69 -> x$69.name()).mkString(" | ")).toString();
        }
        if (namedType instanceof EnumType) {
            EnumType enumType = (EnumType)namedType;
            String nme = enumType.name();
            List<EnumValue> values = enumType.enumValues();
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(39).append("|enum ").append(nme).append(" {\n            |  ").append(values.map((Function1 & Serializable)v -> MODULE$.renderEnumValue((EnumValue)v)).mkString("\n  ")).append("\n            |}").toString()));
        }
        if (namedType instanceof InputObjectType) {
            InputObjectType inputObjectType = (InputObjectType)namedType;
            String nme = inputObjectType.name();
            List<InputValue> fields = inputObjectType.inputFields();
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(40).append("|input ").append(nme).append(" {\n            |  ").append(fields.map((Function1 & Serializable)iv -> MODULE$.renderInputValue((InputValue)iv)).mkString("\n  ")).append("\n            |}").toString()));
        }
        throw new MatchError((Object)namedType);
    }

    public String renderType(Type tpe) {
        return this.loop$3(tpe, false);
    }

    public String renderEnumValue(EnumValue v) {
        EnumValue enumValue = v;
        if (enumValue == null) {
            throw new MatchError((Object)enumValue);
        }
        String nme = enumValue.name();
        boolean isDeprecated = enumValue.isDeprecated();
        Option<String> reason = enumValue.deprecationReason();
        Tuple3 tuple3 = new Tuple3((Object)nme, (Object)BoxesRunTime.boxToBoolean((boolean)isDeprecated), reason);
        String nme2 = (String)tuple3._1();
        boolean isDeprecated2 = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        Option reason2 = (Option)tuple3._3();
        return new StringBuilder(0).append(nme2).append(this.renderDeprecation(isDeprecated2, (Option<String>)reason2)).toString();
    }

    public String renderInputValue(InputValue iv) {
        InputValue inputValue = iv;
        if (inputValue == null) {
            throw new MatchError((Object)inputValue);
        }
        String nme = inputValue.name();
        Type tpe = inputValue.tpe();
        Option<Value> option = inputValue.defaultValue();
        Tuple3 tuple3 = new Tuple3((Object)nme, (Object)tpe, option);
        String nme2 = (String)tuple3._1();
        Type tpe2 = (Type)tuple3._2();
        Option default2 = (Option)tuple3._3();
        String df = (String)default2.map((Function1 & Serializable)v -> new StringBuilder(3).append(" = ").append(MODULE$.renderValue((Value)v)).toString()).getOrElse((Function0 & Serializable)() -> "");
        return new StringBuilder(2).append(nme2).append(": ").append(this.renderType(tpe2)).append(df).toString();
    }

    public String renderValue(Value value2) {
        Value value3 = value2;
        if (value3 instanceof Value.IntValue) {
            Value.IntValue intValue = (Value.IntValue)value3;
            int i = intValue.value();
            return Integer.toString(i);
        }
        if (value3 instanceof Value.FloatValue) {
            Value.FloatValue floatValue = (Value.FloatValue)value3;
            double f = floatValue.value();
            return Double.toString(f);
        }
        if (value3 instanceof Value.StringValue) {
            Value.StringValue stringValue = (Value.StringValue)value3;
            String s = stringValue.value();
            return new StringBuilder(2).append("\"").append(s).append("\"").toString();
        }
        if (value3 instanceof Value.BooleanValue) {
            Value.BooleanValue booleanValue = (Value.BooleanValue)value3;
            boolean b = booleanValue.value();
            return Boolean.toString(b);
        }
        if (value3 instanceof Value.IDValue) {
            Value.IDValue iDValue = (Value.IDValue)value3;
            String i = iDValue.value();
            return new StringBuilder(2).append("\"").append(i).append("\"").toString();
        }
        if (value3 instanceof Value.TypedEnumValue) {
            Value.TypedEnumValue typedEnumValue = (Value.TypedEnumValue)value3;
            EnumValue e = typedEnumValue.value();
            return e.name();
        }
        if (value3 instanceof Value.ListValue) {
            Value.ListValue listValue = (Value.ListValue)value3;
            List<Value> elems = listValue.elems();
            return elems.map((Function1 & Serializable)value -> MODULE$.renderValue((Value)value)).mkString("[", ", ", "]");
        }
        if (value3 instanceof Value.ObjectValue) {
            Value.ObjectValue objectValue = (Value.ObjectValue)value3;
            List<Tuple2<String, Value>> fields = objectValue.fields();
            return fields.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Value value = (Value)tuple2._2();
                    return new StringBuilder(3).append(name).append(" : ").append(MODULE$.renderValue(value)).toString();
                }
                throw new MatchError((Object)tuple2);
            }).mkString("{", ", ", "}");
        }
        return "null";
    }

    public String renderDeprecation(boolean isDeprecated, Option<String> reason) {
        if (isDeprecated) {
            return new StringBuilder(12).append(" @deprecated").append(reason.fold((Function0 & Serializable)() -> "", (Function1 & Serializable)r -> new StringBuilder(12).append("(reason: \"").append((String)r).append("\")").toString())).toString();
        }
        return "";
    }

    private static final String mkRootDef$3(String fieldName, NamedType tpe) {
        return new StringBuilder(2).append(fieldName).append(": ").append(tpe.name()).toString();
    }

    private final String renderField$1(Field f) {
        Field field = f;
        if (field == null) {
            throw new MatchError((Object)field);
        }
        String nme = field.name();
        List<InputValue> args = field.args();
        Type tpe = field.tpe();
        boolean isDeprecated = field.isDeprecated();
        Option<String> reason = field.deprecationReason();
        Tuple5 tuple5 = new Tuple5((Object)nme, args, (Object)tpe, (Object)BoxesRunTime.boxToBoolean((boolean)isDeprecated), reason);
        String nme2 = (String)tuple5._1();
        List args2 = (List)tuple5._2();
        Type tpe2 = (Type)tuple5._3();
        boolean isDeprecated2 = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        Option reason2 = (Option)tuple5._5();
        String dep = this.renderDeprecation(isDeprecated2, (Option<String>)reason2);
        if (args2.isEmpty()) {
            return new StringBuilder(2).append(nme2).append(": ").append(this.renderType(tpe2)).append(dep).toString();
        }
        return new StringBuilder(4).append(nme2).append("(").append(args2.map((Function1 & Serializable)iv -> MODULE$.renderInputValue((InputValue)iv)).mkString(", ")).append("): ").append(this.renderType(tpe2)).append(dep).toString();
    }

    private static final String wrap$2(String tpe, boolean nullable$2) {
        if (nullable$2) {
            return tpe;
        }
        return new StringBuilder(1).append(tpe).append("!").toString();
    }

    private final String loop$3(Type tpe, boolean nullable) {
        Type type;
        while ((type = tpe) instanceof NullableType) {
            NullableType nullableType = (NullableType)type;
            Type tpe2 = nullableType.ofType();
            nullable = true;
            tpe = tpe2;
        }
        if (type instanceof ListType) {
            ListType listType = (ListType)type;
            Type tpe3 = listType.ofType();
            return SchemaRenderer$.wrap$2(new StringBuilder(2).append("[").append(this.loop$3(tpe3, false)).append("]").toString(), nullable);
        }
        if (type instanceof NamedType) {
            NamedType namedType = (NamedType)type;
            return SchemaRenderer$.wrap$2(namedType.name(), nullable);
        }
        throw new MatchError((Object)type);
    }

    private SchemaRenderer$() {
    }
}

