/*
 * Decompiled with CFR 0.152.
 */
package edu.gemini.grackle;

import cats.implicits$;
import cats.syntax.EitherOps$;
import edu.gemini.grackle.Ast;
import edu.gemini.grackle.Ast$Directive$;
import edu.gemini.grackle.Ast$OperationType$Mutation$;
import edu.gemini.grackle.Ast$OperationType$Query$;
import edu.gemini.grackle.Ast$OperationType$Subscription$;
import edu.gemini.grackle.Ast$Value$BooleanValue$;
import edu.gemini.grackle.Ast$Value$EnumValue$;
import edu.gemini.grackle.Ast$Value$FloatValue$;
import edu.gemini.grackle.Ast$Value$IntValue$;
import edu.gemini.grackle.Ast$Value$ListValue$;
import edu.gemini.grackle.Ast$Value$NullValue$;
import edu.gemini.grackle.Ast$Value$ObjectValue$;
import edu.gemini.grackle.Ast$Value$StringValue$;
import edu.gemini.grackle.Ast$Value$Variable$;
import edu.gemini.grackle.Ast$VariableDefinition$;
import edu.gemini.grackle.GraphQLParser$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;

public final class QueryMinimizer$
implements Serializable {
    public static final QueryMinimizer$ MODULE$ = new QueryMinimizer$();

    private QueryMinimizer$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(QueryMinimizer$.class);
    }

    public Either<String, String> minimizeText(String text) {
        Either either = implicits$.MODULE$.catsSyntaxEither(GraphQLParser$.MODULE$.Document().parseAll(text));
        return EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)_$4 -> _$4.expected().toList().mkString(",")).map((Function1 & Serializable)doc -> this.minimizeDocument((List<Ast.Definition>)doc));
    }

    public String minimizeDocument(List<Ast.Definition> doc) {
        return doc.map((Function1 & Serializable)defn -> this.renderDefinition$1((Ast.Definition)defn)).mkString(",");
    }

    private final String renderDefinition$1(Ast.Definition defn) {
        Ast.Definition definition = defn;
        if (definition instanceof Ast.ExecutableDefinition) {
            Ast.ExecutableDefinition e = (Ast.ExecutableDefinition)definition;
            return this.renderExecutableDefinition$1(e);
        }
        return "";
    }

    private final String renderExecutableDefinition$1(Ast.ExecutableDefinition ex) {
        Ast.ExecutableDefinition executableDefinition = ex;
        if (executableDefinition instanceof Ast.OperationDefinition) {
            Ast.OperationDefinition op = (Ast.OperationDefinition)executableDefinition;
            return this.renderOperationDefinition$1(op);
        }
        if (executableDefinition instanceof Ast.FragmentDefinition) {
            Ast.FragmentDefinition frag = (Ast.FragmentDefinition)executableDefinition;
            return this.renderFragmentDefinition$1(frag);
        }
        throw new MatchError((Object)executableDefinition);
    }

    private final String renderOperationDefinition$1(Ast.OperationDefinition op) {
        Ast.OperationDefinition operationDefinition = op;
        if (operationDefinition instanceof Ast.OperationDefinition.QueryShorthand) {
            Ast.OperationDefinition.QueryShorthand qs = (Ast.OperationDefinition.QueryShorthand)operationDefinition;
            return this.renderSelectionSet$1(qs.selectionSet());
        }
        if (operationDefinition instanceof Ast.OperationDefinition.Operation) {
            Ast.OperationDefinition.Operation op2 = (Ast.OperationDefinition.Operation)operationDefinition;
            return this.renderOperation$1(op2);
        }
        throw new MatchError((Object)operationDefinition);
    }

    private final String renderOperation$1$$anonfun$2() {
        return "";
    }

    private final String renderOperation$1(Ast.OperationDefinition.Operation op) {
        return new StringBuilder(0).append(this.renderOperationType$1(op.operationType())).append(op.name().map((Function1 & Serializable)nme -> new StringBuilder(1).append(" ").append(nme.value()).toString()).getOrElse(this::renderOperation$1$$anonfun$2)).append(this.renderVariableDefns$1(op.variables())).append(this.renderDirectives$1(op.directives())).append(this.renderSelectionSet$1(op.selectionSet())).toString();
    }

    private final String renderOperationType$1(Ast.OperationType op) {
        Ast.OperationType operationType = op;
        if (Ast$OperationType$Query$.MODULE$.equals(operationType)) {
            return "query";
        }
        if (Ast$OperationType$Mutation$.MODULE$.equals(operationType)) {
            return "mutation";
        }
        if (Ast$OperationType$Subscription$.MODULE$.equals(operationType)) {
            return "subscription";
        }
        throw new MatchError((Object)operationType);
    }

    private final String renderDirectives$1(List dirs) {
        return dirs.map((Function1 & Serializable)x$1 -> {
            Ast.Directive directive = x$1;
            if (directive != null) {
                Ast.Directive directive2 = Ast$Directive$.MODULE$.unapply(directive);
                Ast.Name name = directive2._1();
                List<Tuple2<Ast.Name, Ast.Value>> list = directive2._2();
                Ast.Name name2 = name;
                List<Tuple2<Ast.Name, Ast.Value>> args = list;
                return new StringBuilder(1).append("@").append(name2.value()).append(this.renderArguments$1(args)).toString();
            }
            throw new MatchError((Object)directive);
        }).mkString();
    }

    private final String renderVariableDefns$1$$anonfun$1$$anonfun$2() {
        return "";
    }

    private final String renderVariableDefns$1(List vars) {
        List list = vars;
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return "";
        }
        return vars.map((Function1 & Serializable)x$1 -> {
            Ast.VariableDefinition variableDefinition = x$1;
            if (variableDefinition != null) {
                Ast.VariableDefinition variableDefinition2 = Ast$VariableDefinition$.MODULE$.unapply(variableDefinition);
                Ast.Name name = variableDefinition2._1();
                Ast.Type type = variableDefinition2._2();
                Option<Ast.Value> option = variableDefinition2._3();
                Ast.Name name2 = name;
                Ast.Type tpe = type;
                Option<Ast.Value> option2 = option;
                return new StringBuilder(2).append("$").append(name2.value()).append(":").append(tpe.name()).append(option2.map((Function1 & Serializable)v -> new StringBuilder(1).append("=").append(this.renderValue$1((Ast.Value)v)).toString()).getOrElse(this::renderVariableDefns$1$$anonfun$1$$anonfun$2)).toString();
            }
            throw new MatchError((Object)variableDefinition);
        }).mkString("(", ",", ")");
    }

    private final String renderSelectionSet$1(List sels) {
        List list = sels;
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return "";
        }
        return sels.map((Function1 & Serializable)sel -> this.renderSelection$1((Ast.Selection)sel)).mkString("{", ",", "}");
    }

    private final String renderSelection$1(Ast.Selection sel) {
        Ast.Selection selection = sel;
        if (selection instanceof Ast.Selection.Field) {
            Ast.Selection.Field f = (Ast.Selection.Field)selection;
            return this.renderField$1(f);
        }
        if (selection instanceof Ast.Selection.FragmentSpread) {
            Ast.Selection.FragmentSpread s = (Ast.Selection.FragmentSpread)selection;
            return this.renderFragmentSpread$1(s);
        }
        if (selection instanceof Ast.Selection.InlineFragment) {
            Ast.Selection.InlineFragment i = (Ast.Selection.InlineFragment)selection;
            return this.renderInlineFragment$1(i);
        }
        throw new MatchError((Object)selection);
    }

    private final String renderField$1$$anonfun$2() {
        return "";
    }

    private final String renderField$1(Ast.Selection.Field f) {
        return new StringBuilder(0).append((String)f.alias().map((Function1 & Serializable)a -> new StringBuilder(1).append(a.value()).append(":").toString()).getOrElse(this::renderField$1$$anonfun$2)).append(f.name().value()).append(this.renderArguments$1(f.arguments())).append(this.renderDirectives$1(f.directives())).append(this.renderSelectionSet$1(f.selectionSet())).toString();
    }

    private final String renderArguments$1(List args) {
        List list = args;
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return "";
        }
        return args.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Ast.Name n = (Ast.Name)tuple2._1();
                Ast.Value v = (Ast.Value)tuple2._2();
                return new StringBuilder(1).append(n.value()).append(":").append(this.renderValue$1(v)).toString();
            }
            throw new MatchError((Object)tuple2);
        }).mkString("(", ",", ")");
    }

    private final String renderInputObject$1(List args) {
        List list = args;
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return "";
        }
        return args.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Ast.Name n = (Ast.Name)tuple2._1();
                Ast.Value v = (Ast.Value)tuple2._2();
                return new StringBuilder(1).append(n.value()).append(":").append(this.renderValue$1(v)).toString();
            }
            throw new MatchError((Object)tuple2);
        }).mkString("{", ",", "}");
    }

    private final String renderTypeCondition$1(Ast.Type tpe) {
        return new StringBuilder(3).append("on ").append(tpe.name()).toString();
    }

    private final String renderFragmentDefinition$1(Ast.FragmentDefinition frag) {
        return new StringBuilder(10).append("fragment ").append(frag.name().value()).append(" ").append(this.renderTypeCondition$1(frag.typeCondition())).append(this.renderDirectives$1(frag.directives())).append(this.renderSelectionSet$1(frag.selectionSet())).toString();
    }

    private final String renderFragmentSpread$1(Ast.Selection.FragmentSpread spread) {
        return new StringBuilder(3).append("...").append(spread.name().value()).append(this.renderDirectives$1(spread.directives())).toString();
    }

    private final String renderInlineFragment$1$$anonfun$2() {
        return "";
    }

    private final String renderInlineFragment$1(Ast.Selection.InlineFragment frag) {
        return new StringBuilder(3).append("...").append(frag.typeCondition().map((Function1 & Serializable)tpe -> this.renderTypeCondition$1((Ast.Type)tpe)).getOrElse(this::renderInlineFragment$1$$anonfun$2)).append(this.renderDirectives$1(frag.directives())).append(this.renderSelectionSet$1(frag.selectionSet())).toString();
    }

    private final String renderValue$1(Ast.Value v2) {
        Ast.Value value = v2;
        if (value instanceof Ast.Value.Variable) {
            Ast.Name name;
            Ast.Value.Variable variable = Ast$Value$Variable$.MODULE$.unapply((Ast.Value.Variable)value);
            Ast.Name name2 = name = variable._1();
            return new StringBuilder(1).append("$").append(name2.value()).toString();
        }
        if (value instanceof Ast.Value.IntValue) {
            int n;
            Ast.Value.IntValue intValue = Ast$Value$IntValue$.MODULE$.unapply((Ast.Value.IntValue)value);
            int value2 = n = intValue._1();
            return BoxesRunTime.boxToInteger((int)value2).toString();
        }
        if (value instanceof Ast.Value.FloatValue) {
            double d;
            Ast.Value.FloatValue floatValue = Ast$Value$FloatValue$.MODULE$.unapply((Ast.Value.FloatValue)value);
            double value3 = d = floatValue._1();
            return BoxesRunTime.boxToDouble((double)value3).toString();
        }
        if (value instanceof Ast.Value.StringValue) {
            String string;
            Ast.Value.StringValue stringValue = Ast$Value$StringValue$.MODULE$.unapply((Ast.Value.StringValue)value);
            String value4 = string = stringValue._1();
            return new StringBuilder(2).append("\"").append(value4).append("\"").toString();
        }
        if (value instanceof Ast.Value.BooleanValue) {
            boolean bl;
            Ast.Value.BooleanValue booleanValue = Ast$Value$BooleanValue$.MODULE$.unapply((Ast.Value.BooleanValue)value);
            boolean value5 = bl = booleanValue._1();
            return BoxesRunTime.boxToBoolean((boolean)value5).toString();
        }
        if (Ast$Value$NullValue$.MODULE$.equals(value)) {
            return "null";
        }
        if (value instanceof Ast.Value.EnumValue) {
            Ast.Name name;
            Ast.Value.EnumValue enumValue = Ast$Value$EnumValue$.MODULE$.unapply((Ast.Value.EnumValue)value);
            Ast.Name name3 = name = enumValue._1();
            return name3.value();
        }
        if (value instanceof Ast.Value.ListValue) {
            List<Ast.Value> list;
            Ast.Value.ListValue listValue = Ast$Value$ListValue$.MODULE$.unapply((Ast.Value.ListValue)value);
            List<Ast.Value> values = list = listValue._1();
            return values.map((Function1 & Serializable)v -> this.renderValue$1((Ast.Value)v)).mkString("[", ",", "]");
        }
        if (value instanceof Ast.Value.ObjectValue) {
            List<Tuple2<Ast.Name, Ast.Value>> list;
            Ast.Value.ObjectValue objectValue = Ast$Value$ObjectValue$.MODULE$.unapply((Ast.Value.ObjectValue)value);
            List<Tuple2<Ast.Name, Ast.Value>> fields = list = objectValue._1();
            return this.renderInputObject$1(fields);
        }
        throw new MatchError((Object)value);
    }
}

