/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.StemScope;
import edu.internet2.middleware.grouperClient.ws.WsMemberFilter;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetGroupsResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetGroupsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestGetGroupsRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcGetGroups {
    private String clientVersion;
    private List<WsSubjectLookup> subjectLookups = new ArrayList<WsSubjectLookup>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private String fieldName;
    private WsSubjectLookup actAsSubject;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private WsMemberFilter memberFilter;
    private String scope;
    private WsStemLookup wsStemLookup;
    private StemScope stemScope;
    private Boolean enabled = Boolean.TRUE;
    private Integer pageSize;
    private Integer pageNumber;
    private String sortString;
    private Boolean ascending;

    public GcGetGroups assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcGetGroups addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcGetGroups addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcGetGroups addSubjectLookup(WsSubjectLookup wsSubjectLookup) {
        this.subjectLookups.add(wsSubjectLookup);
        return this;
    }

    public GcGetGroups addSubjectId(String subjectId) {
        this.subjectLookups.add(new WsSubjectLookup(subjectId, null, null));
        return this;
    }

    public GcGetGroups addSubjectIdentifier(String subjectIdentifier) {
        this.subjectLookups.add(new WsSubjectLookup(null, null, subjectIdentifier));
        return this;
    }

    public GcGetGroups assignFieldName(String theFieldName) {
        this.fieldName = theFieldName;
        return this;
    }

    public GcGetGroups assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.subjectLookups) == 0) {
            throw new RuntimeException("Need at least one subject to add to group: " + this);
        }
    }

    public GcGetGroups assignScope(String theScope) {
        this.scope = theScope;
        return this;
    }

    public GcGetGroups assignWsStemLookup(WsStemLookup theWsStemLookup) {
        this.wsStemLookup = theWsStemLookup;
        return this;
    }

    public GcGetGroups assignStemScope(StemScope theStemScope) {
        this.stemScope = theStemScope;
        return this;
    }

    public GcGetGroups assignEnabled(Boolean theEnabled) {
        this.enabled = theEnabled;
        return this;
    }

    public GcGetGroups assignPageSize(Integer thePageSize) {
        this.pageSize = thePageSize;
        return this;
    }

    public GcGetGroups assignPageNumber(Integer thePageNumber) {
        this.pageNumber = thePageNumber;
        return this;
    }

    public GcGetGroups assignSortString(String theSortString) {
        this.sortString = theSortString;
        return this;
    }

    public GcGetGroups assignAscending(Boolean theAscending) {
        this.ascending = theAscending;
        return this;
    }

    public GcGetGroups addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcGetGroups assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcGetGroups assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public WsGetGroupsResults execute() {
        this.validate();
        WsGetGroupsResults wsGetGroupsResults = null;
        try {
            WsRestGetGroupsRequest getGroups = new WsRestGetGroupsRequest();
            getGroups.setActAsSubjectLookup(this.actAsSubject);
            if (this.includeGroupDetail != null) {
                getGroups.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                getGroups.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            if (this.subjectAttributeNames.size() > 0) {
                getGroups.setSubjectAttributeNames(GrouperClientUtils.toArray(this.subjectAttributeNames, String.class));
            }
            getGroups.setMemberFilter(this.memberFilter == null ? null : this.memberFilter.name());
            getGroups.setScope(this.scope);
            getGroups.setWsStemLookup(this.wsStemLookup);
            getGroups.setStemScope(this.stemScope == null ? null : this.stemScope.name());
            getGroups.setEnabled(this.enabled == null ? "A" : (this.enabled != false ? "T" : "F"));
            getGroups.setPageSize(this.pageSize == null ? null : this.pageSize.toString());
            getGroups.setPageNumber(this.pageNumber == null ? null : this.pageNumber.toString());
            getGroups.setSortString(this.sortString);
            getGroups.setAscending(this.ascending == null ? null : (this.ascending != false ? "T" : "F"));
            getGroups.setFieldName(this.fieldName);
            WsSubjectLookup[] subjectLookupsResults = GrouperClientUtils.toArray(this.subjectLookups, WsSubjectLookup.class);
            getGroups.setSubjectLookups(subjectLookupsResults);
            if (this.params.size() > 0) {
                getGroups.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsGetGroupsResults = (WsGetGroupsResults)grouperClientWs.executeService("subjects", getGroups, "getGroups", this.clientVersion);
            String resultMessage = wsGetGroupsResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsGetGroupsResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsGetGroupsResults;
    }

    public GcGetGroups assignMemberFilter(WsMemberFilter theMemberFilter) {
        this.memberFilter = theMemberFilter;
        return this;
    }

    public static void main(String[] args) {
        WsGetGroupsResults wsGetGroupsResults = new GcGetGroups().addSubjectLookup(new WsSubjectLookup("10021368", null, null)).execute();
        WsGetGroupsResult wsGroupsResult = wsGetGroupsResults.getResults()[0];
        for (WsGroup wsGroup : GrouperClientUtils.nonNull(wsGroupsResult.getWsGroups(), WsGroup.class)) {
            System.out.println(wsGroup.getName());
        }
    }
}

