/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestStemSaveRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemSaveResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemToSave;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.List;

public class GcStemSave {
    private String clientVersion;
    private List<WsStemToSave> stemsToSave = new ArrayList<WsStemToSave>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private GcTransactionType txType;

    public GcStemSave assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcStemSave addStemToSave(WsStemToSave wsStemToSave) {
        this.stemsToSave.add(wsStemToSave);
        return this;
    }

    public GcStemSave addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcStemSave addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcStemSave assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.stemsToSave) == 0) {
            throw new RuntimeException("Stem name is required: " + this);
        }
    }

    public WsStemSaveResults execute() {
        this.validate();
        WsStemSaveResults wsStemSaveResults = null;
        try {
            WsRestStemSaveRequest stemSave = new WsRestStemSaveRequest();
            stemSave.setActAsSubjectLookup(this.actAsSubject);
            stemSave.setTxType(this.txType == null ? null : this.txType.name());
            stemSave.setWsStemToSaves(GrouperClientUtils.toArray(this.stemsToSave, WsStemToSave.class));
            if (this.params.size() > 0) {
                stemSave.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsStemSaveResults = (WsStemSaveResults)grouperClientWs.executeService("stems", stemSave, "stemSave", this.clientVersion);
            String stemSaveResultMessage = "";
            try {
                stemSaveResultMessage = wsStemSaveResults.getResults()[0].getResultMetadata().getResultMessage();
            }
            catch (Exception e) {
                // empty catch block
            }
            String resultMessage = wsStemSaveResults.getResultMetadata().getResultMessage() + "\n" + stemSaveResultMessage;
            grouperClientWs.handleFailure(wsStemSaveResults, wsStemSaveResults.getResults(), resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsStemSaveResults;
    }

    public GcStemSave assignTxType(GcTransactionType gcTransactionType) {
        this.txType = gcTransactionType;
        return this;
    }
}

