/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.util;

import edu.internet2.middleware.grouperClient.examples.PersonXstreamExample;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.WsRestClassLookup;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.XStream;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml.DomDriver;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.mapper.MapperWrapper;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrouperClientXstreamUtils {
    static Log log = GrouperClientUtils.retrieveLog(PersonXstreamExample.class);

    public static XStream retrieveXstream() {
        return GrouperClientXstreamUtils.retrieveXstream(WsRestClassLookup.getAliasClassMap());
    }

    public static XStream retrieveXstream(Map<String, Class<?>> aliasClassMap) {
        boolean ignoreExtraneousFields = GrouperClientUtils.propertiesValueBoolean("grouperClient.webService.ignoreExtraneousXmlFields", true, true);
        XStream xStream = null;
        xStream = ignoreExtraneousFields ? new XStream(new DomDriver()){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper(next){

                    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                        boolean definedInNotObject;
                        boolean bl = definedInNotObject = definedIn != Object.class;
                        if (definedInNotObject) {
                            return super.shouldSerializeMember(definedIn, fieldName);
                        }
                        log.info("Cant find field: " + fieldName);
                        return false;
                    }
                };
            }
        } : new XStream(new DomDriver());
        xStream.setMode(1001);
        for (String key : GrouperClientUtils.nonNull(aliasClassMap).keySet()) {
            xStream.alias(key, aliasClassMap.get(key));
        }
        xStream.autodetectAnnotations(true);
        String fieldsToOmit = GrouperClientUtils.propertiesValue("grouper.webService.omitXmlProperties", false);
        if (!GrouperClientUtils.isBlank(fieldsToOmit)) {
            List<String> fieldsToOmitList = GrouperClientUtils.splitTrimToList(fieldsToOmit, ",");
            for (String fieldToOmit : fieldsToOmitList) {
                if (GrouperClientUtils.isBlank(fieldToOmit)) continue;
                try {
                    int dotIndex = fieldToOmit.lastIndexOf(46);
                    String className = fieldToOmit.substring(0, dotIndex);
                    String propertyName = fieldToOmit.substring(dotIndex + 1, fieldToOmit.length());
                    Class theClass = GrouperClientUtils.forName(className);
                    xStream.omitField(theClass, propertyName);
                }
                catch (Exception e) {
                    throw new RuntimeException("Problem with grouper.webService.omitXmlProperties: " + fieldsToOmit + ", " + e.getMessage(), e);
                }
            }
        }
        return xStream;
    }
}

