/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.mapper;

import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.Converter;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.ConverterLookup;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.SingleValueConverter;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.mapper.Mapper;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.mapper.MapperWrapper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AttributeMapper
extends MapperWrapper {
    private final Map fieldNameToTypeMap = new HashMap();
    private final Set typeSet = new HashSet();
    private ConverterLookup converterLookup;
    private final Set fieldToUseAsAttribute = new HashSet();

    public AttributeMapper(Mapper wrapped) {
        this(wrapped, null);
    }

    public AttributeMapper(Mapper wrapped, ConverterLookup converterLookup) {
        super(wrapped);
        this.converterLookup = converterLookup;
    }

    public void setConverterLookup(ConverterLookup converterLookup) {
        this.converterLookup = converterLookup;
    }

    public void addAttributeFor(String fieldName, Class type) {
        this.fieldNameToTypeMap.put(fieldName, type);
    }

    public void addAttributeFor(Class type) {
        this.typeSet.add(type);
    }

    protected SingleValueConverter getLocalConverterFromItemType(Class type) {
        Converter converter = this.converterLookup.lookupConverterForType(type);
        if (converter != null && converter instanceof SingleValueConverter) {
            return (SingleValueConverter)((Object)converter);
        }
        return null;
    }

    public SingleValueConverter getConverterFromItemType(String fieldName, Class type) {
        if (this.fieldNameToTypeMap.get(fieldName) == type) {
            return this.getLocalConverterFromItemType(type);
        }
        return null;
    }

    public SingleValueConverter getConverterFromItemType(String fieldName, Class type, Class definedIn) {
        SingleValueConverter converter;
        Field field = this.getField(definedIn, fieldName);
        if ((this.fieldToUseAsAttribute.contains(field) || this.fieldNameToTypeMap.get(fieldName) == type || this.typeSet.contains(type)) && (converter = this.getLocalConverterFromItemType(type)) != null) {
            return converter;
        }
        return super.getConverterFromItemType(fieldName, type, definedIn);
    }

    public SingleValueConverter getConverterFromItemType(Class type) {
        if (this.typeSet.contains(type)) {
            return this.getLocalConverterFromItemType(type);
        }
        return null;
    }

    public SingleValueConverter getConverterFromAttribute(String attributeName) {
        SingleValueConverter converter = null;
        Class type = (Class)this.fieldNameToTypeMap.get(attributeName);
        if (type != null) {
            converter = this.getLocalConverterFromItemType(type);
        }
        return converter;
    }

    public SingleValueConverter getConverterFromAttribute(Class definedIn, String attribute) {
        SingleValueConverter converter;
        Field field = this.getField(definedIn, attribute);
        Class type = null;
        if ((this.fieldToUseAsAttribute.contains(field) || (type = (Class)this.fieldNameToTypeMap.get(attribute)) != null || this.typeSet.contains(field.getType())) && (converter = this.getLocalConverterFromItemType(type == null ? field.getType() : type)) != null) {
            return converter;
        }
        return super.getConverterFromAttribute(definedIn, attribute);
    }

    public void addAttributeFor(Field field) {
        this.fieldToUseAsAttribute.add(field);
    }

    public void addAttributeFor(Class definedIn, String fieldName) {
        this.fieldToUseAsAttribute.add(this.getField(definedIn, fieldName));
    }

    private Field getField(Class definedIn, String fieldName) {
        try {
            return definedIn.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(fieldName + " is not a proper field of " + definedIn.getName());
        }
    }
}

