/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl.util.introspection;

import edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl.util.introspection.IntrospectorBase;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl.util.introspection.MethodMap;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import java.lang.reflect.Method;

public class Introspector
extends IntrospectorBase {
    public static final String CACHEDUMP_MSG = "Introspector : detected classloader change. Dumping cache.";
    private final Log rlog;

    public Introspector(Log logger) {
        this.rlog = logger;
    }

    public Method getMethod(Class c, String name, Object[] params) throws Exception {
        try {
            return super.getMethod(c, name, params);
        }
        catch (MethodMap.AmbiguousException ae) {
            StringBuffer msg = new StringBuffer("Introspection Error : Ambiguous method invocation ").append(name).append("( ");
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                msg.append(params[i].getClass().getName());
            }
            msg.append(") for class ").append(c.getName());
            this.rlog.error(msg.toString());
            return null;
        }
    }

    protected void clearCache() {
        super.clearCache();
        this.rlog.info(CACHEDUMP_MSG);
    }
}

