/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;

public class Applet
extends JApplet {
    private static final long serialVersionUID = 7286186605066367207L;

    private String getProjectName() {
        return this.getParameter("project_name");
    }

    private URL getProjectURL() {
        URL url = null;
        try {
            url = new URL(this.getDocumentBase(), this.getProjectName());
        }
        catch (MalformedURLException e) {
            Log.getLogger().severe(Log.toString(e));
        }
        return url;
    }

    public void init() {
        try {
            SystemUtilities.initGraphics();
            SystemUtilities.setApplet(true);
            URL projectURL = this.getProjectURL();
            this.setup(projectURL);
        }
        catch (Exception e) {
            Log.getLogger().severe(Log.toString(e));
            SystemUtilities.pause();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        Applet applet = new Applet();
        frame.getContentPane().add(applet);
        applet.setup(Applet.getURL(args));
        frame.pack();
        frame.setVisible(true);
    }

    private static URL getURL(String[] args) {
        URL url = null;
        try {
            url = new URL(args[0]);
        }
        catch (MalformedURLException e) {
            Log.getLogger().severe(Log.toString(e));
        }
        return url;
    }

    private void setup(final URL projectURL) {
        JButton button = new JButton(Icons.getLogoBannerIcon());
        button.setFocusPainted(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String[] args = projectURL == null ? new String[]{} : new String[]{projectURL.toString()};
                Application.main(args);
            }
        });
        this.getContentPane().add(button);
    }
}

