/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege;

import edu.stanford.smi.protege.exception.ModificationException;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.CreateProjectFromFilePlugin;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.ui.SplashScreen;
import edu.stanford.smi.protege.ui.WelcomeDialog;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class Application {
    private static transient Logger log = Log.getLogger(Application.class);
    private static JFrame _mainFrame;
    private static SplashScreen _splashScreen;
    private static WelcomeDialog _welcome;
    private static final String projectFileExtension = ".pprj";
    private static final String propertyOptionsPrefix = "-prop";
    private static final String serverPropertyOptionsPrefix = "-server";
    private static final String serverUserProperty = "-server.user";
    private static final String serverPasswordProperty = "-server.password";
    private static final String serverHostProperty = "-server.host";
    private static final String serverprojectProperty = "-server.project";

    private static void initialize() {
        try {
            SystemUtilities.initGraphics();
        }
        catch (Exception e) {
            Log.getLogger().log(Level.SEVERE, "failed to initialize", e);
        }
    }

    public static Component getMainWindow() {
        Window result = _splashScreen != null ? _splashScreen : _mainFrame;
        return result;
    }

    private static URI getProjectURI(String[] args) {
        URI uri = null;
        if (args.length > 0) {
            String projectString = args[0];
            if (projectString.startsWith(propertyOptionsPrefix) || projectString.startsWith(serverPropertyOptionsPrefix)) {
                return null;
            }
            if (!projectString.endsWith(projectFileExtension)) {
                projectString = projectString + projectFileExtension;
            }
            uri = URIUtilities.createURI(projectString);
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(String[] args) {
        Application.parseOptions(args);
        _mainFrame = ComponentFactory.createMainFrame();
        _mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                ProjectManager.getProjectManager().exitApplicationRequest();
            }
        });
        Application.restoreMainframeRectangle();
        ProjectManager.getProjectManager().setRootPane(_mainFrame.getRootPane());
        Project project = null;
        if (args.length > 0) {
            String possibleFilename = args[0];
            boolean isFile = false;
            try {
                isFile = new File(possibleFilename).exists();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (isFile) {
                int lastDotIndex = possibleFilename.lastIndexOf(46);
                if (lastDotIndex > 0 && lastDotIndex < possibleFilename.length() - 1 && !possibleFilename.endsWith(projectFileExtension)) {
                    String suffix = possibleFilename.substring(lastDotIndex + 1);
                    Iterator it = PluginUtilities.getAvailableCreateProjectFromFilePluginClassNames().iterator();
                    while (it.hasNext() && project == null) {
                        Class pluginClass = (Class)it.next();
                        project = Application.useCreateProjectFromFilePlugin(pluginClass, suffix, possibleFilename);
                        if (project == null) continue;
                        String projectFilePath = possibleFilename.substring(0, lastDotIndex) + projectFileExtension;
                        project.setProjectFilePath(projectFilePath);
                        ProjectManager.getProjectManager().setCurrentProject(project, false);
                    }
                }
            } else {
                boolean continueLoading = false;
                try {
                    project = Application.getRemoteProject(args);
                }
                catch (IllegalArgumentException e) {
                    continueLoading = true;
                }
                if (project == null && !continueLoading) {
                    return;
                }
            }
        }
        if (project != null) {
            Application.showMainFrame();
        } else {
            URI projectURI = Application.getProjectURI(args);
            if (projectURI != null) {
                try {
                    ProjectManager.getProjectManager().loadProject(projectURI);
                }
                finally {
                    Application.showMainFrame();
                }
            } else {
                Application.showMainFrame();
                if (!SystemUtilities.isApplet()) {
                    String startInServerPanel = ApplicationProperties.getString("ui.welcomedialog.start.in.server.panel", "false");
                    if (startInServerPanel.equalsIgnoreCase("true")) {
                        ProjectManager.getProjectManager().openRemoteProjectRequest();
                    } else if (ApplicationProperties.getWelcomeDialogShow()) {
                        _welcome = new WelcomeDialog(_mainFrame, "Welcome to " + Text.getProgramName(), true);
                        _welcome.setLocationRelativeTo(_mainFrame);
                        _welcome.setVisible(true);
                    }
                } else {
                    ProjectManager.getProjectManager().openRemoteProjectRequest();
                }
            }
        }
    }

    private static Project getRemoteProject(String[] args) {
        Project project = null;
        String host = null;
        String user = null;
        String pass = null;
        String prjName = null;
        for (int i = 0; i < args.length; ++i) {
            String option = args[i];
            try {
                if (option.startsWith(serverHostProperty)) {
                    host = Application.extractValue(option);
                    continue;
                }
                if (option.startsWith(serverUserProperty)) {
                    user = Application.extractValue(option);
                    continue;
                }
                if (option.startsWith(serverPasswordProperty)) {
                    pass = Application.extractValue(option);
                    continue;
                }
                if (!option.startsWith(serverprojectProperty)) continue;
                prjName = Application.extractValue(option);
                continue;
            }
            catch (Throwable t) {
                Log.getLogger().log(Level.WARNING, "Error at parsing argument: " + option + ". This argument will be ignored.", t);
            }
        }
        if (host == null || user == null || pass == null || prjName == null) {
            throw new IllegalArgumentException("Insufficient arguments");
        }
        project = ProjectManager.getProjectManager().openRemoteProjectRequest(host, user, pass, prjName);
        if (project == null) {
            Application.showMainFrame();
            MessageError messageError = new MessageError("Loading remote project " + prjName + " from server " + host + " failed.\n" + "Please check your username and password and try again.");
            ProjectManager.getProjectManager().displayErrors("Could not load remote project " + prjName, CollectionUtilities.createCollection(messageError));
        }
        return project;
    }

    private static String extractValue(String option) {
        int index = option.indexOf("=");
        if (index != -1) {
            String value = option.substring(index + 1);
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            return value;
        }
        return null;
    }

    public static Project useCreateProjectFromFilePlugin(Class pluginClass, String suffix, String arg) {
        if (pluginClass != null) {
            try {
                CreateProjectFromFilePlugin p;
                Object plugin = pluginClass.newInstance();
                if (plugin instanceof CreateProjectFromFilePlugin && PluginUtilities.isSuitableCreateProjectFromFilePlugin(p = (CreateProjectFromFilePlugin)plugin, suffix)) {
                    File file = new File(arg);
                    ArrayList errors = new ArrayList();
                    Project project = p.createProject(file, errors);
                    Log.handleErrors(log, Level.WARNING, errors);
                    return project;
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Warning: Failed handle argument with " + pluginClass, ex);
            }
        }
        return null;
    }

    public static WelcomeDialog getWelcomeDialog() {
        return _welcome;
    }

    private static void restoreMainframeRectangle() {
        ApplicationProperties.restoreMainFrameProperties(_mainFrame);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        Rectangle r = gc.getBounds();
        Dimension frameSize = _mainFrame.getSize();
        frameSize.width = Math.min(frameSize.width, r.width);
        frameSize.height = Math.min(frameSize.height, r.height);
        _mainFrame.setSize(frameSize);
        Point location = _mainFrame.getLocation();
        location.x = Math.max(r.x, location.x);
        location.y = Math.max(r.y, location.y);
        _mainFrame.setLocation(location);
    }

    public static void main(final String[] args) {
        ThreadGroup group = new ThreadGroup(Thread.currentThread().getThreadGroup(), "Safe Thread Group"){

            public void uncaughtException(Thread thread, Throwable throwable) {
                Log.getLogger().log(Level.SEVERE, "Uncaught Exception", throwable);
                Application.handleModificationException(throwable);
            }
        };
        Thread thread = new Thread(group, "Safe Main Thread"){

            public void run() {
                try {
                    Application.realmain(args);
                }
                catch (Throwable t) {
                    Log.getLogger().log(Level.INFO, "Exception caught", t);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        SystemUtilities.sleepMsec(5000);
    }

    public static void realmain(String[] args) {
        Application.initialize();
        _splashScreen = new SplashScreen();
        try {
            Application.init(args);
        }
        catch (Exception e) {
            Log.getLogger().log(Level.SEVERE, "failed to initialize", e);
        }
        _splashScreen.dispose();
        _splashScreen = null;
    }

    private static void parseOptions(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String option = args[i];
            try {
                int index;
                if (!option.startsWith(propertyOptionsPrefix) || (index = option.indexOf("=")) == -1) continue;
                String propName = option.substring(5, index);
                String value = option.substring(index + 1);
                ApplicationProperties.setString(propName, value);
                continue;
            }
            catch (Throwable t) {
                Log.getLogger().log(Level.WARNING, "Error at parsing or setting application property: " + option + ". This option will be ignored.", t);
            }
        }
    }

    public static void repaint() {
        if (_mainFrame != null) {
            _mainFrame.repaint();
        }
    }

    private static void showMainFrame() {
        _splashScreen.setVisible(false);
        _mainFrame.setVisible(true);
        ProjectManager.getProjectManager().bringErrorFrameToFront();
    }

    public static void shutdown() {
        _mainFrame.dispatchEvent(new WindowEvent(_mainFrame, 201));
    }

    private static boolean handleModificationException(Throwable t) {
        boolean foundModEx = false;
        for (Throwable exception = t; !foundModEx && exception != null; exception = exception.getCause()) {
            if (!(exception instanceof ModificationException)) continue;
            if (_mainFrame != null) {
                ModalDialog.showMessageDialog((Component)_mainFrame, "You do not have permission to make this modification.", "Write error");
            }
            foundModEx = true;
            break;
        }
        return foundModEx;
    }
}

