/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.action;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;

class ChangeIncludedProjectsPanel
extends JComponent {
    private static final long serialVersionUID = 8112876043190298819L;
    private SelectableList _list;

    ChangeIncludedProjectsPanel(Project project) {
        this.setLayout(new BorderLayout());
        this._list = ComponentFactory.createSelectableList(null);
        ComponentUtilities.setListValues(this._list, project.getDirectIncludedProjectURIs());
        LabeledComponent c = new LabeledComponent("Directly Included Projects", new JScrollPane(this._list));
        c.addHeaderButton(this.createSelectProjectAction());
        c.addHeaderButton(this.createRemoveProjectAction(this._list));
        this.add(c);
        this.setPreferredSize(new Dimension(300, 300));
    }

    public Collection getIncludedProjectURIs() {
        return ComponentUtilities.getListValues(this._list);
    }

    private Action createSelectProjectAction() {
        return new AddAction(ResourceKey.PROJECT_ADD){
            private static final long serialVersionUID = -8349519785941796661L;

            public void onAdd() {
                JFileChooser chooser = ComponentFactory.createFileChooser("Select Project", "Project Files", "pprj");
                int openDialogResult = chooser.showOpenDialog(ChangeIncludedProjectsPanel.this);
                switch (openDialogResult) {
                    case -1: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 0: {
                        ComponentUtilities.addListValue(ChangeIncludedProjectsPanel.this._list, chooser.getSelectedFile().toURI());
                        break;
                    }
                    default: {
                        Assert.fail("bad result: " + openDialogResult);
                    }
                }
            }
        };
    }

    private Action createRemoveProjectAction(SelectableList list) {
        return new RemoveAction(ResourceKey.PROJECT_REMOVE, (Selectable)list){
            private static final long serialVersionUID = -3939574688291304185L;

            public void onRemove(Collection values) {
                ComponentUtilities.removeListValues(ChangeIncludedProjectsPanel.this._list, values);
            }
        };
    }
}

