/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.action;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.ArchiveManager;
import edu.stanford.smi.protege.util.ArchiveRecord;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ConfigureArchivePanel
extends JPanel {
    private static final long serialVersionUID = 4467651841510373106L;
    private Project _currentProject;

    public ConfigureArchivePanel(Project project) {
        super(new BorderLayout());
        this._currentProject = project;
        this.add((Component)this.createExistingArchiveVersionsPanel(), "Center");
        this.add((Component)ConfigureArchivePanel.createOptionsPanel(), "South");
    }

    private static JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        panel.add(ConfigureArchivePanel.createAutoArchivePanel());
        panel.add(ConfigureArchivePanel.createNumberOfArchivedVersionsPanel());
        return panel;
    }

    private static JComponent createAutoArchivePanel() {
        return new JCheckBox("Automatically archive the current version on Save");
    }

    private static JComponent createNumberOfArchivedVersionsPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(ComponentFactory.createLabel("Maximum number of archived versions"));
        panel.add(new JTextField(5));
        return panel;
    }

    private JComponent createExistingArchiveVersionsPanel() {
        JTable table = new JTable();
        table.setModel(this.createTableModel());
        LabeledComponent c = new LabeledComponent("Archived Versions", ComponentFactory.createScrollPane(table));
        c.addHeaderButton(ConfigureArchivePanel.createDeleteVersionButton());
        return c;
    }

    private static Action createDeleteVersionButton() {
        return new AbstractAction("Delete Selected Version", Icons.getDeleteIcon()){
            private static final long serialVersionUID = 7721643833354014740L;

            public void actionPerformed(ActionEvent event) {
                Log.getLogger().info("delete selected version");
            }
        };
    }

    private TableModel createTableModel() {
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn("Date and Time");
        model.addColumn("Comment");
        for (ArchiveRecord record : ArchiveManager.getArchiveManager().getArchiveRecords(this._currentProject)) {
            Date timestamp = record.getTimestamp();
            String comment = record.getComment();
            model.addRow(new Object[]{timestamp, comment});
        }
        return model;
    }
}

