/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.action;

import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.event.ActionEvent;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public class ConvertUnicodeSequenceAction
extends TextAction {
    private static final long serialVersionUID = -7504061449538436768L;

    public ConvertUnicodeSequenceAction() {
        super(LocalizedText.getText(ResourceKey.CONVERT_UNICODE_SEQUENCE_ACTION));
    }

    public void actionPerformed(ActionEvent event) {
        JTextComponent component = this.getTextComponent(event);
        StringBuffer text = new StringBuffer(component.getText());
        int pos = component.getCaretPosition();
        int startPos = Math.max(pos - 4, 0);
        String sequence = text.substring(startPos, pos);
        try {
            char code = (char)Integer.valueOf(sequence, 16).intValue();
            text = text.replace(startPos, pos, Character.toString(code));
            component.setText(text.toString());
            component.setCaretPosition(startPos + 1);
        }
        catch (NumberFormatException exception) {
            SystemUtilities.beep();
        }
    }
}

