/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.action;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.DeleteAction;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import javax.swing.JComponent;

public class DeleteInstancesAction
extends DeleteAction {
    private static final long serialVersionUID = 8355065882937698045L;

    public DeleteInstancesAction(Selectable selectable) {
        this(ResourceKey.INSTANCE_DELETE, selectable);
    }

    public DeleteInstancesAction(ResourceKey key, Selectable selectable) {
        super(key, selectable);
    }

    @Deprecated
    public DeleteInstancesAction(String text, Selectable selectable) {
        super(text, selectable);
    }

    private boolean canDelete(Instance instance) {
        boolean result = true;
        if (instance instanceof Cls) {
            Cls cls = (Cls)instance;
            int instanceCount = cls.getInstanceCount();
            boolean bl = result = instanceCount == 0;
            if (!result) {
                String text = LocalizedText.getText(ResourceKey.DELETE_CLASS_FAILED_DIALOG_TEXT);
                ModalDialog.showMessageDialog((JComponent)((Object)this.getSelectable()), text);
            }
        }
        return result;
    }

    protected void onAboutToDelete(Object o) {
    }

    protected void onAfterDelete(Object o) {
    }

    public void onDelete(Object o) {
        Instance instance = (Instance)o;
        if (this.canDelete(instance)) {
            this.onAboutToDelete(instance);
            this.deleteInstance(instance);
            this.onAfterDelete(o);
        }
    }

    public void deleteInstance(Instance instance) {
        instance.getKnowledgeBase().deleteFrame(instance);
    }

    public void onSelectionChange() {
        boolean isEditable = true;
        for (Instance instance : this.getSelection()) {
            if (instance.isEditable()) continue;
            isEditable = false;
            break;
        }
        this.setAllowed(isEditable);
    }
}

