/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.action;

import edu.stanford.smi.protege.action.ExportToCsvUtil;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.impl.UnbackedOperationImpl;
import edu.stanford.smi.protege.ui.ExportConfigurationPanel;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.FrameWithBrowserText;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.StandardAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportToCsvAction
extends StandardAction {
    private static final long serialVersionUID = 8536785619825508769L;
    public static final Operation EXPORT_TO_CSV_OPERATION = new UnbackedOperationImpl("ExportToCSV", null);
    private static final char NEW_LINE = '\n';
    private static final char QUOTE_CHAR = '\"';
    private KnowledgeBase kb;
    private Collection<Instance> instancesToExport = new ArrayList<Instance>();
    private File exportFile;
    private Collection<Slot> slotsToExport = new ArrayList<Slot>();
    private String exportMetadataText;
    private boolean exportHeader;
    private boolean exportTypes;
    private boolean exportMetadata;
    private boolean exportSuperclass;
    private boolean exportCompletedSuccessul = false;
    private ExportConfigurationPanel exportConfigurationPanel;

    public ExportToCsvAction(KnowledgeBase kb) {
        this(kb, "Export Slot Values to file", Icons.getQueryExportIcon());
    }

    protected ExportToCsvAction(KnowledgeBase kb, String name, Icon icon) {
        super(name, icon);
        this.kb = kb;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.exportCompletedSuccessul = false;
        this.exportConfigurationPanel = this.getExportConfigurationPanel();
        this.exportConfigurationPanel.setPossibleSlots(this.getSlotsToExport());
        this.exportConfigurationPanel.setExportMetadata(this.exportMetadataText);
        this.exportConfigurationPanel.setInitialExportClasses(this.getInitialExportClses());
        int sel = ModalDialog.showDialog(this.getParentComponent(), this.exportConfigurationPanel.getConfigPanel(), "Export configuration", 11);
        if (sel == 4) {
            return;
        }
        this.exportFile = this.exportConfigurationPanel.getExportedFile();
        this.slotsToExport = this.exportConfigurationPanel.getExportedSlots();
        this.exportHeader = this.exportConfigurationPanel.isExportHeaderEnabled();
        this.exportTypes = this.exportConfigurationPanel.isExportTypesEnabled();
        this.exportSuperclass = this.exportConfigurationPanel.isExportSuperclassEnabled();
        this.exportMetadata = this.exportConfigurationPanel.isExportMetadataEnabled();
        this.setSlotsDelimiter(this.exportConfigurationPanel.getSlotDelimiter());
        this.setSlotValuesDelimiter(this.exportConfigurationPanel.getSlotValuesDelimiter());
        this.setExportBrowserText(this.exportConfigurationPanel.isExportBrowserTextEnabled());
        this.setExportMetadata(this.exportConfigurationPanel.isExportMetadataEnabled());
        this.setExportSuperclass(this.exportConfigurationPanel.isExportSuperclassEnabled());
        this.setExportMetadata(this.exportConfigurationPanel.getExportMetadataText());
        this.exportCompletedSuccessul = this.export();
        String messageText = this.exportCompletedSuccessul ? "Query results exported successfully to:\n" + this.exportFile.getAbsolutePath() : "There were errors at saving query results.\nPlease consult the console for more details.";
        ModalDialog.showMessageDialog(this.getParentComponent(), messageText, this.exportCompletedSuccessul ? "Export successful" : "Errors at export");
    }

    public boolean export() {
        boolean success = false;
        try {
            BufferedWriter outputStream = FileUtilities.createBufferedWriter(this.exportFile);
            if (outputStream == null) {
                Log.getLogger().log(Level.WARNING, "Unable to open output file " + this.exportFile + ".");
            } else {
                this.printResults(outputStream, this.getInstancesToExport(), this.slotsToExport);
                success = true;
            }
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.WARNING, "Errors at writing out query results file " + this.exportFile + ".", ex);
        }
        return success;
    }

    protected void printResults(Writer writer, Collection<Instance> instances, Collection<Slot> slots) {
        PrintWriter output = new PrintWriter(writer);
        if (this.exportHeader) {
            this.printHeader(output, slots);
        }
        for (Instance instance : instances) {
            this.printInstance(output, instance);
        }
        if (this.exportMetadata) {
            this.printMetadata(output);
        }
        output.close();
    }

    private void printMetadata(PrintWriter writer) {
        if (this.exportMetadataText == null || this.exportMetadataText.length() == 0) {
            return;
        }
        writer.println();
        writer.println();
        writer.println(this.getQuotedValule(this.exportMetadataText));
    }

    protected void printHeader(PrintWriter writer, Collection<Slot> slots) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Instance");
        buffer.append(this.getSlotsDelimiter());
        if (this.exportTypes) {
            buffer.append("Type(s)");
            buffer.append(this.getSlotsDelimiter());
        }
        if (this.exportSuperclass) {
            buffer.append("Superclass(es)");
            buffer.append(this.getSlotsDelimiter());
        }
        Iterator<Slot> i$ = slots.iterator();
        while (i$.hasNext()) {
            Slot element;
            Slot slot = element = i$.next();
            buffer.append(this.getExportName(slot));
            buffer.append(this.getSlotsDelimiter());
        }
        writer.println(buffer.toString());
    }

    protected void printInstance(PrintWriter writer, Instance instance) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getExportName(instance));
        if (this.exportTypes) {
            buffer.append(ExportToCsvUtil.getSlotsDelimiter());
            Collection directTypes = instance.getDirectTypes();
            Iterator i = directTypes.iterator();
            while (i.hasNext()) {
                Cls directType = (Cls)i.next();
                buffer.append(this.getExportName(directType));
                if (!i.hasNext()) continue;
                buffer.append(this.getSlotValuesDelimiter());
            }
        }
        if (this.exportSuperclass) {
            buffer.append(ExportToCsvUtil.getSlotsDelimiter());
            Iterator<Cls> i = this.getSuperclassesToExport(instance).iterator();
            while (i.hasNext()) {
                Cls supercls = i.next();
                buffer.append(this.getExportName(supercls));
                if (!i.hasNext()) continue;
                buffer.append(this.getSlotValuesDelimiter());
            }
        }
        if (!this.slotsToExport.isEmpty()) {
            for (Slot slot : this.slotsToExport) {
                buffer.append(this.getSlotsDelimiter());
                buffer.append(this.getSlotValuesExportString(instance, slot));
            }
        }
        writer.println(buffer.toString());
    }

    protected String getSlotValuesExportString(Instance instance, Slot slot) {
        StringBuffer buffer = new StringBuffer();
        Collection values = instance.getOwnSlotValues(slot);
        Iterator i = values.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            if (value instanceof Frame) {
                Frame frame = (Frame)value;
                buffer.append(this.getExportName(frame));
            } else {
                buffer.append(this.getExportDataValueName(value));
            }
            if (!i.hasNext()) continue;
            buffer.append(this.getSlotValuesDelimiter());
        }
        return this.getQuotedValule(buffer.toString());
    }

    protected String getQuotedValule(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        StringBuffer buffer = new StringBuffer(value);
        for (int i = 0; i < buffer.length(); ++i) {
            if (buffer.charAt(i) != '\"') continue;
            buffer.insert(i, '\"');
            ++i;
        }
        buffer.insert(0, '\"');
        buffer.insert(buffer.length(), '\"');
        return buffer.toString();
    }

    protected String getExportName(Frame frame) {
        return this.getQuotedValule(this.isExportBrowserTextEnabled() ? frame.getBrowserText() : frame.getName());
    }

    protected String getExportDataValueName(Object data) {
        return data.toString();
    }

    protected ExportConfigurationPanel getExportConfigurationPanel() {
        if (this.exportConfigurationPanel != null) {
            return this.exportConfigurationPanel;
        }
        this.exportConfigurationPanel = new ExportConfigurationPanel(this.kb);
        return this.exportConfigurationPanel;
    }

    protected Collection<Cls> getSuperclassesToExport(Instance inst) {
        ArrayList<Cls> superclses = new ArrayList<Cls>();
        if (!(inst instanceof Cls)) {
            return superclses;
        }
        Cls cls = (Cls)inst;
        return cls.getDirectSuperclasses();
    }

    protected Component getParentComponent() {
        return ProjectManager.getProjectManager().getCurrentProjectView();
    }

    protected Collection<Cls> getInitialExportClses() {
        return new ArrayList<Cls>();
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.kb;
    }

    public Collection<Instance> getInstancesToExport() {
        return this.instancesToExport;
    }

    public void setInstancesToExport(Collection<Instance> instancesToExport) {
        this.instancesToExport = instancesToExport;
    }

    public void setFramesWithBrowserTextToExport(Collection<FrameWithBrowserText> frames) {
        this.instancesToExport = new ArrayList<Instance>();
        for (FrameWithBrowserText frameWithBrowserText : frames) {
            Frame frame = frameWithBrowserText.getFrame();
            if (!(frame instanceof Instance)) continue;
            this.instancesToExport.add((Instance)frame);
        }
    }

    public File getExportFile() {
        return this.exportFile;
    }

    public void setExportFile(File exportFile) {
        this.exportFile = exportFile;
    }

    public Collection<Slot> getSlotsToExport() {
        return this.slotsToExport;
    }

    public void setSlotsToExport(Collection<Slot> slotsToExport) {
        this.slotsToExport = slotsToExport;
    }

    public void setExportMetadata(String metadata) {
        this.exportMetadataText = metadata;
    }

    public String getExportMetadata() {
        return this.exportMetadataText;
    }

    public boolean isExportHeader() {
        return this.exportHeader;
    }

    public void setExportHeader(boolean exportHeader) {
        this.exportHeader = exportHeader;
    }

    public boolean isExportTypes() {
        return this.exportTypes;
    }

    public void setExportTypes(boolean exportTypes) {
        this.exportTypes = exportTypes;
    }

    public boolean isExportMetadata() {
        return this.exportMetadata;
    }

    public void setExportMetadata(boolean exportMetadata) {
        this.exportMetadata = exportMetadata;
        ExportToCsvUtil.setExportMetadata(exportMetadata);
    }

    public void setExportSuperclass(boolean exportSuperclass) {
        this.exportSuperclass = exportSuperclass;
        ExportToCsvUtil.setExportSuperclass(exportSuperclass);
    }

    public boolean isExportSuperclass() {
        return this.exportSuperclass;
    }

    public String getSlotValuesDelimiter() {
        return ExportToCsvUtil.getSlotValuesDelimiter();
    }

    public void setSlotValuesDelimiter(String slotValuesDelimiter) {
        ExportToCsvUtil.setSlotValuesDelimiter(slotValuesDelimiter);
    }

    public String getSlotsDelimiter() {
        return ExportToCsvUtil.getSlotsDelimiter();
    }

    public void setSlotsDelimiter(String slotsDelimiter) {
        ExportToCsvUtil.setSlotsDelimiter(slotsDelimiter);
    }

    public boolean isExportBrowserTextEnabled() {
        return ExportToCsvUtil.isExportBrowserTextEnabled();
    }

    public void setExportBrowserText(boolean exportBrowserText) {
        ExportToCsvUtil.setExportBrowserText(exportBrowserText);
    }

    public boolean exportCompletedSuccessful() {
        return this.exportCompletedSuccessul;
    }
}

